/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.util.QueryNavigatorCollectorVisitor;
import com.atlassian.jira.issue.search.searchers.util.QuerySearcherInputHelper;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultQuerySearcherInputHelper
implements QuerySearcherInputHelper {
    private final String queryParameter;
    private final JqlOperandResolver operandResolver;

    public DefaultQuerySearcherInputHelper(String queryParameter, JqlOperandResolver operandResolver) {
        this.queryParameter = (String)Assertions.notNull((String)"queryParameter", (Object)queryParameter);
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
    }

    @Override
    public Map<String, String> convertClause(Clause clause, User user) {
        if (clause == null) {
            return null;
        }
        List<TerminalClause> queryClauses = this.validateClauseStructure(clause);
        if (queryClauses == null) {
            return null;
        }
        String descriptionQueryString = this.getValueForField(queryClauses, user, SystemSearchConstants.forDescription().getJqlClauseNames().getJqlFieldNames());
        String environmentQueryString = this.getValueForField(queryClauses, user, SystemSearchConstants.forEnvironment().getJqlClauseNames().getJqlFieldNames());
        String summaryQueryString = this.getValueForField(queryClauses, user, SystemSearchConstants.forSummary().getJqlClauseNames().getJqlFieldNames());
        String commentQueryString = this.getValueForField(queryClauses, user, SystemSearchConstants.forComments().getJqlClauseNames().getJqlFieldNames());
        String queryString = this.queryStringAllSameIgnoreNull(descriptionQueryString, environmentQueryString, summaryQueryString, commentQueryString);
        LinkedHashMap<String, String> fieldValuesHolder = null;
        if (queryString != null) {
            fieldValuesHolder = new LinkedHashMap<String, String>();
            fieldValuesHolder.put(this.queryParameter, queryString);
            if (descriptionQueryString != null) {
                fieldValuesHolder.put(SystemSearchConstants.forDescription().getUrlParameter(), "true");
            }
            if (environmentQueryString != null) {
                fieldValuesHolder.put(SystemSearchConstants.forEnvironment().getUrlParameter(), "true");
            }
            if (summaryQueryString != null) {
                fieldValuesHolder.put(SystemSearchConstants.forSummary().getUrlParameter(), "true");
            }
            if (commentQueryString != null) {
                fieldValuesHolder.put(SystemSearchConstants.forComments().getUrlParameter(), "true");
            }
        }
        return fieldValuesHolder;
    }

    List<TerminalClause> validateClauseStructure(Clause clause) {
        QueryNavigatorCollectorVisitor collector = new QueryNavigatorCollectorVisitor();
        clause.accept((ClauseVisitor)collector);
        List foundChildren = collector.getClauses();
        if (!collector.isValid() || foundChildren.isEmpty() || this.checkForDuplicates(foundChildren) || this.checkForEmpties(foundChildren)) {
            return null;
        }
        return foundChildren;
    }

    private boolean checkForDuplicates(List<TerminalClause> foundChildren) {
        HashSet<String> containsSet = new HashSet<String>();
        for (TerminalClause foundChild : foundChildren) {
            if (containsSet.add(foundChild.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean checkForEmpties(List<TerminalClause> foundChildren) {
        for (TerminalClause foundChild : foundChildren) {
            Operand operand = foundChild.getOperand();
            if (!this.operandResolver.isEmptyOperand(operand)) continue;
            return true;
        }
        return false;
    }

    private String getValueForField(List<TerminalClause> terminalClauses, User user, Set<String> jqlClauseNames) {
        Operand operand;
        QueryLiteral rawValue;
        TerminalClause theClause = null;
        for (TerminalClause terminalClause : terminalClauses) {
            if (!jqlClauseNames.contains(terminalClause.getName())) continue;
            if (theClause != null) {
                return null;
            }
            theClause = terminalClause;
        }
        if (theClause != null && (rawValue = this.operandResolver.getSingleValue(user, operand = theClause.getOperand(), theClause)) != null && !rawValue.isEmpty()) {
            return rawValue.asString();
        }
        return null;
    }

    private String queryStringAllSameIgnoreNull(String descriptionQueryString, String environmentQueryString, String summaryQueryString, String commentQueryString) {
        HashSet<String> queryStringSet = new HashSet<String>();
        if (descriptionQueryString != null) {
            queryStringSet.add(descriptionQueryString);
        }
        if (environmentQueryString != null) {
            queryStringSet.add(environmentQueryString);
        }
        if (summaryQueryString != null) {
            queryStringSet.add(summaryQueryString);
        }
        if (commentQueryString != null) {
            queryStringSet.add(commentQueryString);
        }
        return queryStringSet.size() == 1 ? (String)queryStringSet.iterator().next() : null;
    }
}

