/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.impl.NamedTerminalClauseCollectingVisitor;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.issue.search.searchers.util.UserFitsNavigatorHelper;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UserSearchInputTransformer
implements SearchInputTransformer {
    private static final Logger log = Logger.getLogger(UserSearchInputTransformer.class);
    protected final UserFieldSearchConstants searchConstants;
    protected final UserFitsNavigatorHelper userFitsNavigatorHelper;
    protected final GroupManager groupManager;
    protected final UserManager userManager;
    protected final String emptySelectFlag;

    public UserSearchInputTransformer(UserFieldSearchConstantsWithEmpty searchConstants, UserFitsNavigatorHelper userFitsNavigatorHelper, GroupManager groupManager, UserManager userManager) {
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.emptySelectFlag = searchConstants.getEmptySelectFlag();
        this.searchConstants = searchConstants;
        this.userFitsNavigatorHelper = userFitsNavigatorHelper;
    }

    public UserSearchInputTransformer(UserFieldSearchConstants searchConstants, UserFitsNavigatorHelper userFitsNavigatorHelper, GroupManager groupManager, UserManager userManager) {
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.emptySelectFlag = null;
        this.searchConstants = searchConstants;
        this.userFitsNavigatorHelper = userFitsNavigatorHelper;
    }

    public void populateFromParams(User searcher, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        fieldValuesHolder.put((Object)this.searchConstants.getSelectUrlParameter(), (Object)actionParams.getFirstValueForKey(this.searchConstants.getSelectUrlParameter()));
        if (actionParams.containsKey(this.searchConstants.getFieldUrlParameter()) && !actionParams.containsKey(this.searchConstants.getSelectUrlParameter())) {
            fieldValuesHolder.put((Object)this.searchConstants.getSelectUrlParameter(), (Object)this.searchConstants.getSpecificUserSelectFlag());
        }
        fieldValuesHolder.put((Object)this.searchConstants.getFieldUrlParameter(), (Object)actionParams.getFirstValueForKey(this.searchConstants.getFieldUrlParameter()));
    }

    public void validateParams(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        String user = (String)fieldValuesHolder.get((Object)this.searchConstants.getFieldUrlParameter());
        if (StringUtils.isNotBlank((String)user)) {
            String userTypeSelectList = (String)fieldValuesHolder.get((Object)this.searchConstants.getSelectUrlParameter());
            if (this.searchConstants.getSpecificUserSelectFlag().equals(userTypeSelectList)) {
                if (!this.userExists(user)) {
                    errors.addError(this.searchConstants.getFieldUrlParameter(), i18nHelper.getText("admin.errors.could.not.find.username", user));
                }
            } else if (this.searchConstants.getSpecificGroupSelectFlag().equals(userTypeSelectList) && !this.groupExists(user)) {
                errors.addError(this.searchConstants.getFieldUrlParameter(), i18nHelper.getText("admin.errors.abstractusersearcher.could.not.find.group", user));
            }
        }
    }

    public void populateFromQuery(User searcher, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        if (query == null) {
            return;
        }
        List<TerminalClause> clauses = this.getMatchingClauses(this.searchConstants.getJqlClauseNames().getJqlFieldNames(), query);
        for (TerminalClause clause : clauses) {
            Operand operand = clause.getOperand();
            if (operand instanceof SingleValueOperand) {
                SingleValueOperand svop = (SingleValueOperand)operand;
                String stringValue = svop.getStringValue() == null ? svop.getLongValue().toString() : svop.getStringValue();
                String user = this.userFitsNavigatorHelper.checkUser(stringValue);
                if (user == null) continue;
                fieldValuesHolder.put((Object)this.searchConstants.getFieldUrlParameter(), (Object)user);
                fieldValuesHolder.put((Object)this.searchConstants.getSelectUrlParameter(), (Object)this.searchConstants.getSpecificUserSelectFlag());
                continue;
            }
            if (operand instanceof FunctionOperand) {
                FunctionOperand fop = (FunctionOperand)operand;
                if ("membersOf".equalsIgnoreCase(fop.getName()) && fop.getArgs().size() == 1) {
                    String group = (String)fop.getArgs().get(0);
                    fieldValuesHolder.put((Object)this.searchConstants.getFieldUrlParameter(), (Object)group);
                    fieldValuesHolder.put((Object)this.searchConstants.getSelectUrlParameter(), (Object)this.searchConstants.getSpecificGroupSelectFlag());
                    continue;
                }
                if (!"currentUser".equalsIgnoreCase(fop.getName())) continue;
                fieldValuesHolder.put((Object)this.searchConstants.getSelectUrlParameter(), (Object)this.searchConstants.getCurrentUserSelectFlag());
                continue;
            }
            if (operand instanceof EmptyOperand && this.emptySelectFlag != null) {
                fieldValuesHolder.put((Object)this.searchConstants.getSelectUrlParameter(), (Object)this.emptySelectFlag);
                continue;
            }
            log.warn((Object)("Operand '" + operand + "' cannot be processed in navigator for query '" + query + "'."));
        }
    }

    public boolean doRelevantClausesFitFilterForm(User searcher, Query query, SearchContext searchContext) {
        if (query != null && query.getWhereClause() != null) {
            SimpleNavigatorCollectorVisitor visitor = this.createSimpleNavigatorCollectorVisitor();
            Clause whereClause = query.getWhereClause();
            whereClause.accept((ClauseVisitor)visitor);
            List clauses = visitor.getClauses();
            if (clauses.size() == 0) {
                return true;
            }
            if (clauses.size() != 1 || !visitor.isValid()) {
                return false;
            }
            TerminalClause clause = (TerminalClause)clauses.get(0);
            Operator operator = clause.getOperator();
            Operand operand = clause.getOperand();
            if (operand instanceof SingleValueOperand) {
                if (operator == Operator.EQUALS) {
                    SingleValueOperand svop = (SingleValueOperand)operand;
                    String user = svop.getStringValue() == null ? svop.getLongValue().toString() : svop.getStringValue();
                    return this.userFitsNavigatorHelper.checkUser(user) != null;
                }
                return false;
            }
            if (operand instanceof FunctionOperand) {
                FunctionOperand fop = (FunctionOperand)operand;
                if ("membersOf".equalsIgnoreCase(fop.getName()) && fop.getArgs().size() == 1 && operator == Operator.IN) {
                    return true;
                }
                return "currentUser".equalsIgnoreCase(fop.getName()) && operator == Operator.EQUALS && this.isUserLoggedIn(searcher);
            }
            return operand instanceof EmptyOperand && this.emptySelectFlag != null && (operator == Operator.EQUALS || operator == Operator.IS);
        }
        return true;
    }

    public Clause getSearchClause(User searcher, FieldValuesHolder fieldValuesHolder) {
        String clauseName = this.searchConstants.getJqlClauseNames().getPrimaryName();
        if (this.emptySelectFlag != null && ParameterUtils.paramContains((Map)fieldValuesHolder, (String)this.searchConstants.getSelectUrlParameter(), (String)this.emptySelectFlag)) {
            return new TerminalClauseImpl(clauseName, Operator.IS, (Operand)new EmptyOperand());
        }
        if (ParameterUtils.paramContains((Map)fieldValuesHolder, (String)this.searchConstants.getSelectUrlParameter(), (String)this.searchConstants.getCurrentUserSelectFlag())) {
            return new TerminalClauseImpl(clauseName, Operator.EQUALS, (Operand)new FunctionOperand("currentUser"));
        }
        if (fieldValuesHolder.containsKey((Object)this.searchConstants.getFieldUrlParameter()) && (!fieldValuesHolder.containsKey((Object)this.searchConstants.getSelectUrlParameter()) || ParameterUtils.paramContains((Map)fieldValuesHolder, (String)this.searchConstants.getSelectUrlParameter(), (String)this.searchConstants.getSpecificUserSelectFlag()))) {
            String user = ParameterUtils.getStringParam((Map)fieldValuesHolder, (String)this.searchConstants.getFieldUrlParameter());
            return new TerminalClauseImpl(clauseName, Operator.EQUALS, user);
        }
        if (ParameterUtils.paramContains((Map)fieldValuesHolder, (String)this.searchConstants.getSelectUrlParameter(), (String)this.searchConstants.getSpecificGroupSelectFlag()) && fieldValuesHolder.containsKey((Object)this.searchConstants.getFieldUrlParameter())) {
            String group = ParameterUtils.getStringParam((Map)fieldValuesHolder, (String)this.searchConstants.getSelectUrlParameter(), (String)this.searchConstants.getSpecificUserSelectFlag(), (String)this.searchConstants.getFieldUrlParameter());
            return new TerminalClauseImpl(clauseName, Operator.IN, (Operand)new FunctionOperand("membersOf", new String[]{group}));
        }
        return null;
    }

    protected List<TerminalClause> getMatchingClauses(Set<String> jqlClauseNames, Query query) {
        NamedTerminalClauseCollectingVisitor clauseVisitor = new NamedTerminalClauseCollectingVisitor(jqlClauseNames);
        if (query.getWhereClause() != null) {
            query.getWhereClause().accept((ClauseVisitor)clauseVisitor);
            return clauseVisitor.getNamedClauses();
        }
        return Collections.emptyList();
    }

    boolean isUserLoggedIn(User user) {
        return user != null;
    }

    boolean groupExists(String user) {
        return this.groupManager.groupExists(user);
    }

    boolean userExists(String user) {
        return this.userManager.getUserObject(user) != null;
    }

    SimpleNavigatorCollectorVisitor createSimpleNavigatorCollectorVisitor() {
        return new SimpleNavigatorCollectorVisitor(this.searchConstants.getJqlClauseNames().getJqlFieldNames());
    }
}

