/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractProjectConstantsRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final SimpleFieldSearchConstantsWithEmpty searchConstants;
    private final FieldVisibilityManager fieldVisibilityManager;

    public AbstractProjectConstantsRenderer(VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, FieldVisibilityManager fieldVisibilityManager, SimpleFieldSearchConstantsWithEmpty searchConstants, String searcherNameKey) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, searchConstants.getSearcherId(), searcherNameKey);
        this.searchConstants = searchConstants;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public boolean isRelevantForQuery(User searcher, Query query) {
        return this.isRelevantForQuery(this.searchConstants.getJqlClauseNames(), query);
    }

    public boolean isShown(User searcher, SearchContext searchContext) {
        return searchContext.isSingleProjectContext() && !this.getSelectListOptions(searcher, searchContext).isEmpty() && !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(this.searchConstants.getFieldId(), searchContext, searcher);
    }

    abstract List<Option> getSelectListOptions(User var1, SearchContext var2);

    Collection<GenericProjectConstantsLabel> getSelectedObjects(FieldValuesHolder fieldValuesHolder, Function<String, GenericProjectConstantsLabel> function) {
        return this.getSelectedObjects((Collection)fieldValuesHolder.get((Object)this.searchConstants.getUrlParameter()), function);
    }

    <T> Collection<GenericProjectConstantsLabel> getSelectedObjects(Collection<T> selectedValues, Function<T, GenericProjectConstantsLabel> function) {
        if (selectedValues != null && !selectedValues.isEmpty()) {
            return CollectionUtil.transform(selectedValues, function);
        }
        return null;
    }

    Collection<GenericProjectConstantsLabel> filterDuplicateSelectedObjects(Collection<GenericProjectConstantsLabel> selectedObjects, Collection<Option> validOptions) {
        ArrayList filteredObjects = Lists.newArrayList();
        for (GenericProjectConstantsLabel label : selectedObjects) {
            boolean duplicate = false;
            for (GenericProjectConstantsLabel existingLabel : filteredObjects) {
                if (!existingLabel.getLabel().equals(label.getLabel())) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            boolean valid = false;
            for (Option option : validOptions) {
                if (!label.isSameAs(option)) continue;
                valid = true;
                break;
            }
            filteredObjects.add(new GenericProjectConstantsLabel(label.getLabel(), valid));
        }
        return filteredObjects;
    }

    public static class GenericProjectConstantsLabel {
        private final String browseUrl;
        private final String label;
        private final boolean valid;

        public GenericProjectConstantsLabel(String label) {
            this(label, null, true);
        }

        public GenericProjectConstantsLabel(String label, String browseUrl) {
            this(label, browseUrl, true);
        }

        public GenericProjectConstantsLabel(String label, boolean valid) {
            this(label, null, valid);
        }

        public GenericProjectConstantsLabel(String label, String browseUrl, boolean valid) {
            this.browseUrl = browseUrl;
            this.label = label;
            this.valid = valid;
        }

        public String getLabel() {
            return this.label;
        }

        public String getBrowseUrl() {
            return this.browseUrl;
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean isSameAs(Option option) {
            String name = option.getName();
            return null == this.label ? null == name : this.label.equals(name);
        }
    }
}

