/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.AbstractLanguageAnalyser;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cjk.CJKTokenizer;
import org.apache.lucene.util.Version;

public class CJKAnalyzer
extends AbstractLanguageAnalyser {
    private final Set<?> stopWords;
    private final Version matchVersion;

    public CJKAnalyzer(Version matchVersion, boolean indexing) {
        super(indexing);
        this.matchVersion = matchVersion;
        this.stopWords = org.apache.lucene.analysis.cjk.CJKAnalyzer.getDefaultStopSet();
    }

    public final TokenStream tokenStream(String fieldname, Reader reader) {
        CJKTokenizer result = new CJKTokenizer(reader);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, this.stopWords);
        return result;
    }
}

