/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.option;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.OptionSetManagerImpl;
import com.atlassian.jira.issue.fields.option.OptionSetPersister;
import com.atlassian.jira.util.cache.JiraCachedManager;
import com.atlassian.jira.util.cache.ManagedCache;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import java.util.Collection;
import javax.annotation.Nullable;

@EventComponent
public class CachedOptionSetManager
implements OptionSetManager,
JiraCachedManager {
    private final ManagedCache<FieldConfig, OptionSet> cache = ManagedCache.newManagedCache(new OptionSetForConfig(), new KeyFromFieldConfig());
    private final OptionSetManagerImpl optionSetManager;

    public CachedOptionSetManager(OptionSetPersister optionSetPersister, ConstantsManager constantsManager) {
        this.optionSetManager = new OptionSetManagerImpl(optionSetPersister, constantsManager);
        this.init();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refreshCache();
    }

    public void init() {
        this.cache.clear();
    }

    public OptionSet getOptionsForConfig(FieldConfig config) {
        return this.cache.get((FieldConfig)Assertions.notNull((String)"config", (Object)config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionSet createOptionSet(FieldConfig config, Collection optionIds) {
        Assertions.notNull((String)"config", (Object)config);
        try {
            OptionSet optionSet = this.optionSetManager.createOptionSet(config, optionIds);
            return optionSet;
        }
        finally {
            this.cache.remove(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionSet updateOptionSet(FieldConfig config, Collection optionIds) {
        Assertions.notNull((String)"config", (Object)config);
        try {
            OptionSet optionSet = this.optionSetManager.updateOptionSet(config, optionIds);
            return optionSet;
        }
        finally {
            this.cache.remove(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOptionSet(FieldConfig config) {
        Assertions.notNull((String)"config", (Object)config);
        try {
            this.optionSetManager.removeOptionSet(config);
        }
        finally {
            this.cache.remove(config);
        }
    }

    @Override
    public long getCacheSize() {
        return this.cache.size();
    }

    @Override
    public void refreshCache() {
        this.init();
    }

    private static class KeyFromFieldConfig
    implements Function<FieldConfig, Long> {
        private KeyFromFieldConfig() {
        }

        public Long apply(@Nullable FieldConfig fieldConfig) {
            return fieldConfig.getId();
        }
    }

    private class OptionSetForConfig
    implements Function<FieldConfig, OptionSet> {
        private OptionSetForConfig() {
        }

        public OptionSet apply(@Nullable FieldConfig fieldConfig) {
            return CachedOptionSetManager.this.optionSetManager.getOptionsForConfig(fieldConfig);
        }
    }
}

