/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class LongIdsValueHolder
extends LinkedList<Long> {
    private final List<String> badStrings = new LinkedList<String>();

    public static LongIdsValueHolder fromFieldValuesHolder(String id, Map params) {
        Object o = params.get(id);
        if (o instanceof LongIdsValueHolder) {
            return (LongIdsValueHolder)o;
        }
        if (o instanceof Collection) {
            LongIdsValueHolder vh = new LongIdsValueHolder((List<Long>)new ArrayList<Long>((Collection)o));
            params.put(vh, id);
            return vh;
        }
        return null;
    }

    public LongIdsValueHolder(List<Long> componentIds) {
        super(componentIds);
    }

    public LongIdsValueHolder(String[] value) {
        this((Collection<String>)(null == value ? null : Arrays.asList(value)));
    }

    public LongIdsValueHolder(Collection<String> value) {
        if (value != null && !value.isEmpty()) {
            for (String aValue : value) {
                try {
                    this.add(new Long(aValue));
                }
                catch (NumberFormatException e) {
                    this.badStrings.add(aValue);
                }
            }
        }
    }

    public List<Long> getComponentIds() {
        return this;
    }

    public String getInputText() {
        return StringUtils.join(this.badStrings, (String)"");
    }

    public void addBadId(Long componentId) {
        this.badStrings.add("" + componentId);
    }

    public void validateIds(Predicate<Long> predicate) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Long id = (Long)it.next();
            if (predicate.apply((Object)id)) continue;
            it.remove();
            this.addBadId(id);
        }
    }
}

