/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.converters.UserConverter;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldValueGeneratingClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.UserPickerGroupCustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.UserCustomFieldIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.UserSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.UserFitsNavigatorHelper;
import com.atlassian.jira.issue.statistics.CustomFieldUserStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.UserCustomFieldClauseQueryFactory;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.UserCustomFieldValidator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.jql.values.UserClauseValuesGenerator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public class UserPickerGroupSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
SortableCustomFieldSearcher,
CustomFieldStattable {
    private final String USER_SELECT_SUFFIX = "Select";
    private final UserConverter userConverter;
    private final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final VelocityTemplatingEngine templatingEngine;
    private final ApplicationProperties applicationProperties;
    private final UserPickerSearchService userPickerSearchService;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final UserResolver userResolver;
    private final UserManager userManager;
    private CustomFieldInputHelper customFieldInputHelper;
    private SearcherInformation<CustomField> searcherInformation;
    private SearchRenderer searchRenderer;
    private SearchInputTransformer searchInputTransformer;
    private SimpleCustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    private final GroupManager groupManager;
    private I18nHelper.BeanFactory beanFactory = ComponentAccessor.getI18nHelperFactory();
    private final UserUtil userUtil;
    private final PermissionManager permissionManager;

    public UserPickerGroupSearcher(UserConverter userConverter, JiraAuthenticationContext jiraAuthenticationContext, VelocityRequestContextFactory velocityRequestContextFactory, VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, UserPickerSearchService userPickerSearchService, FieldVisibilityManager fieldVisibilityManager, JqlOperandResolver jqlOperandResolver, UserResolver userResolver, UserManager userManager, CustomFieldInputHelper customFieldInputHelper, GroupManager groupManager, UserUtil userUtil, PermissionManager permissionManager) {
        this.userConverter = userConverter;
        this.authenticationContext = jiraAuthenticationContext;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.templatingEngine = templatingEngine;
        this.applicationProperties = applicationProperties;
        this.userPickerSearchService = userPickerSearchService;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.userResolver = userResolver;
        this.userManager = userManager;
        this.customFieldInputHelper = customFieldInputHelper;
        this.groupManager = groupManager;
        this.userUtil = userUtil;
        this.permissionManager = permissionManager;
    }

    public void init(CustomField field) {
        ClauseNames names = field.getClauseNames();
        UserFieldSearchConstants searchConstants = new UserFieldSearchConstants(field.getId(), names, field.getId(), field.getId() + "Select", field.getId(), field.getId(), "issue_current_user", "specificuser", "specificgroup", OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY);
        UserCustomFieldIndexer indexer = new UserCustomFieldIndexer(this.fieldVisibilityManager, field, this.userConverter);
        UserFitsNavigatorHelper userFitsNavigatorHelper = new UserFitsNavigatorHelper(this.userPickerSearchService);
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new UserPickerGroupCustomFieldRenderer(field, searchConstants, field.getNameKey(), this.velocityRequestContextFactory, this.applicationProperties, this.templatingEngine, this.userPickerSearchService, this.fieldVisibilityManager, this.userManager, this.userUtil, this.groupManager, this.permissionManager);
        this.searchInputTransformer = new UserSearchInputTransformer(searchConstants, userFitsNavigatorHelper, this.groupManager, this.userManager);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldValueGeneratingClauseHandler((ClauseValidator)new UserCustomFieldValidator(this.userResolver, this.jqlOperandResolver, this.beanFactory), (ClauseQueryFactory)new UserCustomFieldClauseQueryFactory(field.getId(), this.userResolver, this.jqlOperandResolver), (ClauseValuesGenerator)new UserClauseValuesGenerator(this.userPickerSearchService), OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.USER);
    }

    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    public LuceneFieldSorter getSorter(CustomField customField) {
        return new CustomFieldUserStatisticsMapper(customField, this.userManager, this.authenticationContext, this.customFieldInputHelper);
    }

    public StatisticsMapper getStatisticsMapper(CustomField customField) {
        return new CustomFieldUserStatisticsMapper(customField, this.userManager, this.authenticationContext, this.customFieldInputHelper);
    }
}

