/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.config.util.IndexWriterConfiguration;
import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriterWrapper
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(WriterWrapper.class);
    private final IndexWriter writer;
    private final Supplier<IndexSearcher> indexSearcherSupplier;

    @VisibleForTesting
    WriterWrapper(Supplier<IndexWriter> writerFactory, Supplier<IndexSearcher> indexSearcherSupplier) {
        this.writer = (IndexWriter)writerFactory.get();
        this.indexSearcherSupplier = indexSearcherSupplier;
    }

    WriterWrapper(final @NotNull Configuration configuration, final Index.UpdateMode mode, Supplier<IndexSearcher> indexSearcherSupplier) {
        this(new Supplier<IndexWriter>(){

            public IndexWriter get() {
                try {
                    IndexWriterConfiguration.WriterSettings writerSettings = configuration.getWriterSettings(mode);
                    IndexWriterConfig luceneConfig = writerSettings.getWriterConfiguration(configuration.getAnalyzer());
                    return new IndexWriter(configuration.getDirectory(), luceneConfig);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }, indexSearcherSupplier);
    }

    @Override
    public void addDocuments(@NotNull Collection<Document> documents) throws IOException {
        for (Document document : documents) {
            this.writer.addDocument((Document)Assertions.notNull((String)"document", (Object)document));
        }
    }

    @Override
    public void deleteDocuments(@NotNull Term identifyingTerm) throws IOException {
        this.writer.deleteDocuments((Term)Assertions.notNull((String)"identifyingTerm", (Object)identifyingTerm));
    }

    @Override
    public void updateDocuments(@NotNull Term identifyingTerm, @NotNull Collection<Document> documents) throws IOException {
        if (documents.size() == 1) {
            this.writer.updateDocument(identifyingTerm, documents.iterator().next());
        } else {
            this.writer.deleteDocuments(identifyingTerm);
            for (Document document : documents) {
                this.writer.addDocument(document);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDocumentConditionally(@NotNull Term identifyingTerm, @NotNull Document document, @NotNull String optimisticLockField) throws IOException {
        BooleanQuery updateCondition = new BooleanQuery(true);
        updateCondition.add(new BooleanClause((Query)new TermQuery(identifyingTerm), BooleanClause.Occur.MUST));
        updateCondition.add(new BooleanClause((Query)new TermQuery(new Term(optimisticLockField, document.get(optimisticLockField))), BooleanClause.Occur.MUST));
        IndexSearcher searcher = (IndexSearcher)this.indexSearcherSupplier.get();
        try {
            TopDocs topDocs = searcher.search((Query)updateCondition, 1);
            if (topDocs.totalHits > 0) {
                this.writer.updateDocument(identifyingTerm, document);
            }
        }
        finally {
            WriterWrapper.closeQuietly(searcher);
        }
    }

    @Override
    public void optimize() throws IOException {
        this.writer.optimize();
    }

    @Override
    public void commit() {
        try {
            this.writer.commit();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static void closeQuietly(IndexSearcher searcher) {
        try {
            if (searcher != null) {
                searcher.close();
            }
        }
        catch (IOException e) {
            log.error("Error closing: " + searcher, (Throwable)e);
        }
    }
}

