/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.validation;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.mapper.IssueTypeMapper;
import com.atlassian.jira.imports.project.util.IssueTypeImportHelper;
import com.atlassian.jira.imports.project.validation.IssueTypeMapperValidator;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import java.util.Iterator;

public class IssueTypeMapperValidatorImpl
implements IssueTypeMapperValidator {
    private final ConstantsManager constantsManager;
    private final IssueTypeImportHelper issueTypeImportHelper;
    private final SubTaskManager subTaskManager;

    public IssueTypeMapperValidatorImpl(ConstantsManager constantsManager, IssueTypeImportHelper issueTypeImportHelper, SubTaskManager subTaskManager) {
        this.constantsManager = constantsManager;
        this.issueTypeImportHelper = issueTypeImportHelper;
        this.subTaskManager = subTaskManager;
    }

    @Override
    public MessageSet validateMappings(I18nHelper i18nHelper, BackupProject backupProject, IssueTypeMapper issueTypeMapper) {
        MessageSetImpl messageSet = new MessageSetImpl();
        Iterator iterator = issueTypeMapper.getRequiredOldIds().iterator();
        while (iterator.hasNext()) {
            String issueTypeDisplayName;
            boolean errorFoundForThisIssue = false;
            String oldId = (String)iterator.next();
            String newId = issueTypeMapper.getMappedId(oldId);
            IssueType newIssueType = newId == null ? this.issueTypeImportHelper.getIssueTypeForName(issueTypeMapper.getKey(oldId)) : this.constantsManager.getIssueTypeObject(newId);
            if (newIssueType == null) {
                if (issueTypeMapper.isSubTask(oldId)) {
                    if (this.subTaskManager.isSubTasksEnabled()) {
                        messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issue.type.validation.subtask.does.not.exist", issueTypeMapper.getDisplayName(oldId)));
                        messageSet.addErrorMessageInEnglish("Sub-tasks are currently disabled in JIRA, please enable sub-tasks. The sub-task issue type '" + issueTypeMapper.getDisplayName(oldId) + "' is required for the import but does not exist in the current JIRA instance.");
                        continue;
                    }
                    messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issue.type.validation.subtask.does.not.exist.not.enabled", issueTypeMapper.getDisplayName(oldId)));
                    messageSet.addErrorMessageInEnglish("The issue type '" + issueTypeMapper.getDisplayName(oldId) + "' is required for the import but does not exist in the current JIRA instance.");
                    continue;
                }
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issue.type.validation.does.not.exist", issueTypeMapper.getDisplayName(oldId)));
                messageSet.addErrorMessageInEnglish("The issue type '" + issueTypeMapper.getDisplayName(oldId) + "' is required for the import but does not exist in the current JIRA instance.");
                continue;
            }
            if (!this.issueTypeImportHelper.isIssueTypeValidForProject(backupProject.getProject().getKey(), newIssueType.getId())) {
                issueTypeDisplayName = issueTypeMapper.getDisplayName(oldId);
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issue.type.validation.not.in.scheme", issueTypeDisplayName));
                messageSet.addErrorMessageInEnglish("The issue type '" + issueTypeDisplayName + "' exists in the system but is not valid for the projects issue type scheme.");
                errorFoundForThisIssue = true;
            }
            if (issueTypeMapper.isSubTask(oldId) && !newIssueType.isSubTask()) {
                issueTypeDisplayName = issueTypeMapper.getDisplayName(oldId);
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issue.type.validation.subtask.normal", issueTypeDisplayName));
                messageSet.addErrorMessageInEnglish("The issue type '" + issueTypeDisplayName + "' is defined as a sub-task in the backup project, but it is a normal issue type in the current JIRA instance.");
                errorFoundForThisIssue = true;
            } else if (!issueTypeMapper.isSubTask(oldId) && newIssueType.isSubTask()) {
                issueTypeDisplayName = issueTypeMapper.getDisplayName(oldId);
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issue.type.validation.normal.subtask", issueTypeDisplayName));
                messageSet.addErrorMessageInEnglish("The issue type '" + issueTypeDisplayName + "' is defined as a normal issue type in the backup project, but it is a sub-task issue type in the current JIRA instance.");
                errorFoundForThisIssue = true;
            }
            if (newId != null || errorFoundForThisIssue) continue;
            issueTypeDisplayName = issueTypeMapper.getDisplayName(oldId);
            messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issue.type.validation.required.not.mapped", issueTypeDisplayName));
            messageSet.addErrorMessageInEnglish("The issue type '" + issueTypeDisplayName + "' is required for the import but it is not mapped.");
        }
        return messageSet;
    }
}

