/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.mail;

import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.listeners.mail.MailListener;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.mail.IssueMailQueueItemFactory;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.user.util.UserManager;

public class DebugMailListener
extends MailListener {
    public DebugMailListener(NotificationSchemeManager notificationSchemeManager, IssueMailQueueItemFactory issueMailQueueItemFactory, UserManager userManager) {
        super(notificationSchemeManager, issueMailQueueItemFactory, userManager);
    }

    @Override
    protected void sendNotification(IssueEvent event) {
        this.logEvent((JiraEvent)event);
    }

    protected void sendUserMail(UserEvent event, String subject, String template) {
        this.logEvent((JiraEvent)event);
        this.log("Subject: " + subject);
        this.log("Template: " + template);
    }

    private void logEvent(JiraEvent event) {
        try {
            if (event instanceof IssueEvent) {
                IssueEvent issueEvent = (IssueEvent)event;
                this.log("Issue: [#" + issueEvent.getIssue().getLong("id") + "] " + issueEvent.getIssue().getString("summary"));
                this.log("Comment: " + issueEvent.getComment());
                this.log("Change Group: " + issueEvent.getChangeLog());
                this.log("EventTypeId: " + issueEvent.getEventTypeId());
            } else if (event instanceof UserEvent) {
                UserEvent userEvent = (UserEvent)event;
                this.log("User: " + userEvent.getUser().getName() + " (" + userEvent.getUser().getEmailAddress() + ")");
            }
            this.log(" Time: " + event.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void log(String msg) {
        System.err.println("[DebugMailListener]: " + msg);
    }

    @Override
    public boolean isInternal() {
        return false;
    }
}

