/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.event.spi.ListenerInvoker;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventListener;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class IssueEventListenerHandler
implements ListenerHandler {
    private static final Logger log = Logger.getLogger(IssueEventListenerHandler.class);

    public List<? extends ListenerInvoker> getInvokers(Object o) {
        if (o instanceof IssueEventListener) {
            return Collections.singletonList(new IssueEventInvoker((IssueEventListener)o));
        }
        return Collections.emptyList();
    }

    class IssueEventInvoker
    implements ListenerInvoker {
        private final IssueEventListener issueEventListener;

        public IssueEventInvoker(IssueEventListener issueEventListener) {
            this.issueEventListener = issueEventListener;
        }

        public Set<Class<?>> getSupportedEventTypes() {
            return Collections.singleton(IssueEvent.class);
        }

        public void invoke(Object o) {
            if (o instanceof IssueEvent) {
                try {
                    this.issueEventListener.workflowEvent((IssueEvent)o);
                }
                catch (Throwable t) {
                    log.error((Object)("Exception thrown from listener [" + this.issueEventListener.getClass().getName() + "] : " + t.getMessage()), t);
                }
            }
        }

        public boolean supportAsynchronousEvents() {
            return false;
        }
    }
}

