/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.JiraListener;
import com.atlassian.jira.event.ListenerFactory;
import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class DefaultListenerManager
implements ListenerManager,
Startable {
    private static final Logger log = Logger.getLogger(DefaultListenerManager.class);
    private static final Collection<String> DELETED_LISTENERS = ImmutableSet.of((Object)"com.atlassian.jira.event.listeners.cache.IssueCacheListener");
    private final Listeners listeners = new Listeners();
    private final EventPublisher eventPublisher;
    private final OfBizDelegator ofBizDelegator;

    public DefaultListenerManager(EventPublisher eventPublisher, OfBizDelegator ofBizDelegator) {
        this.eventPublisher = (EventPublisher)Assertions.notNull((String)"eventPublisher", (Object)eventPublisher);
        this.ofBizDelegator = ofBizDelegator;
    }

    public void start() throws Exception {
        this.listeners.start();
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.listeners.reset();
    }

    public Map<String, JiraListener> getListeners() {
        if (!ComponentManager.getInstance().getState().isComponentsRegistered()) {
            throw new IllegalStateException("Listeners are not available until all components have been registered with the ComponentManager. Components can implement the " + Startable.class + " to be notified when the system is ready.");
        }
        return (Map)this.listeners.get();
    }

    public JiraListener createListener(String name, Class<? extends JiraListener> clazz) {
        this.ofBizDelegator.createValue("ListenerConfig", (Map)FieldMap.build((String)"name", (Object)name).add("clazz", (Object)clazz.getName()));
        this.refresh();
        return this.getListeners().get(name);
    }

    public void deleteListener(Class<? extends JiraListener> clazz) {
        List listenerConfigs = this.ofBizDelegator.findByAnd("ListenerConfig", (Map)FieldMap.build((String)"clazz", (Object)clazz.getName()));
        if (listenerConfigs.size() > 0) {
            this.ofBizDelegator.removeAll(new ArrayList(listenerConfigs));
            this.refresh();
        }
    }

    public void refresh() {
        this.listeners.reset();
    }

    private final class Listeners
    extends ResettableLazyReference<Map<String, JiraListener>> {
        private Listeners() {
        }

        protected Map<String, JiraListener> create() throws Exception {
            Map<String, JiraListener> jiraListenerMap = this.loadListeners();
            this.registerDBListeners(jiraListenerMap.values());
            return jiraListenerMap;
        }

        public void reset() {
            Map map = (Map)this.get();
            super.reset();
            for (JiraListener listener : map.values()) {
                DefaultListenerManager.this.eventPublisher.unregister((Object)listener);
            }
            this.get();
        }

        void start() {
            this.get();
        }

        private Map<String, JiraListener> loadListeners() {
            MapBuilder listeners = MapBuilder.newBuilder();
            List listenerConfigs = DefaultListenerManager.this.ofBizDelegator.findAll("ListenerConfig");
            if (listenerConfigs == null) {
                log.info((Object)"No Listeners to Load");
                return Collections.emptyMap();
            }
            for (GenericValue gv : listenerConfigs) {
                String className = gv.getString("clazz");
                String key = gv.getString("name");
                if (DELETED_LISTENERS.contains(className)) {
                    log.debug((Object)("Not loading deleted listener: " + className));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating listener. Class: " + className + ". Name: " + key));
                }
                try {
                    listeners.add((Object)key, (Object)ListenerFactory.getListener(className, this.getParameters(gv)));
                }
                catch (Exception e) {
                    log.error((Object)("Could not configure listener: " + key + " className:" + className), (Throwable)e);
                }
            }
            return listeners.toMap();
        }

        private Map<String, String> getParameters(GenericValue gv) {
            PropertySet ps = OFBizPropertyUtils.getPropertySet(gv);
            Collection paramKeys = ps.getKeys(5);
            MapBuilder params = MapBuilder.newBuilder();
            for (String key : paramKeys) {
                params.add((Object)key, (Object)ps.getString(key));
            }
            return params.toMap();
        }

        private void registerDBListeners(Collection<JiraListener> listeners) {
            for (JiraListener listener : listeners) {
                DefaultListenerManager.this.eventPublisher.register((Object)listener);
            }
        }
    }
}

