/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.gui;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.config.database.DatabaseDriverRegisterer;
import com.atlassian.jira.configurator.Configurator;
import com.atlassian.jira.configurator.config.ComplexConfigurationReason;
import com.atlassian.jira.configurator.config.ConnectionPoolField;
import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.SettingsLoader;
import com.atlassian.jira.configurator.config.SslSettings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.config.Validator;
import com.atlassian.jira.configurator.config.WebServerProfile;
import com.atlassian.jira.configurator.db.DatabaseConfigPanel;
import com.atlassian.jira.configurator.db.HsqlConfigPanel;
import com.atlassian.jira.configurator.db.MySqlConfigPanel;
import com.atlassian.jira.configurator.db.OracleConfigPanel;
import com.atlassian.jira.configurator.db.PostgresConfigPanel;
import com.atlassian.jira.configurator.db.SqlServerConfigPanel;
import com.atlassian.jira.configurator.gui.ConfigPanelBuilder;
import com.atlassian.jira.configurator.gui.ConnectionTestDialog;
import com.atlassian.jira.configurator.gui.DisabledComboBoxRenderer;
import com.atlassian.jira.configurator.gui.LabelledComponent;
import com.atlassian.jira.configurator.gui.VerticalFlowLayout;
import com.atlassian.jira.configurator.ssl.CertificateDetails;
import com.atlassian.jira.configurator.ssl.CertificatePrettyPrinter;
import com.atlassian.jira.configurator.ssl.DefaultKeyStoreProvider;
import com.atlassian.jira.configurator.ssl.KeyStoreAccessor;
import com.atlassian.jira.configurator.ssl.KeyStoreAccessorImpl;
import com.atlassian.jira.exception.ParseException;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;

public class ConfiguratorFrame
extends JFrame {
    private final JTextField tfJiraHome = new JTextField(32);
    private final JTextField tfControlPort = new JTextField(10);
    private final JLabel tooComplexConfigurationWarning = new JLabel();
    private final JComboBox cbWebServerProfile = new JComboBox();
    private final JTextField tfHttpPort = new JTextField(10);
    private final JTextField tfHttpsPort = new JTextField(10);
    private final JTextField tfKeyStorePath = new JTextField(32);
    private final JButton browseKeyStoreButton = new JButton("Browse");
    private final JTextField tfKeyStorePassword = new JTextField(32);
    private final JTextField tfKeyAlias = new JTextField(10);
    private final JButton checkCertificate = new JButton("Check Certificate in Key Store");
    private final Map<ConnectionPoolField, LabelledComponent> advancedSettings = new HashMap<ConnectionPoolField, LabelledComponent>();
    private JComboBox ddDatabaseType;
    private JPanel cardPanel;
    private CardLayout jdbcTypeCardLayout;
    private Map<DatabaseType, DatabaseConfigPanel> configPanelMap = null;
    final ConnectionTestDialog connectionTestDialog;
    private String previousJiraHome;
    private KeyStoreAccessor keyStoreAccessor;

    public ConfiguratorFrame() {
        this.init();
        this.connectionTestDialog = new ConnectionTestDialog(this);
        this.keyStoreAccessor = new KeyStoreAccessorImpl(new DefaultKeyStoreProvider());
    }

    private void init() {
        this.setIconImage(new ImageIcon("../atlassian-jira/images/64jira.png").getImage());
        this.setLayout(new BorderLayout());
        this.add(this.newTabbedPanel(), "Center");
        this.add((Component)this.newButtonPanel(), "South");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConfiguratorFrame.this.closeApplication();
            }
        });
        this.pack();
    }

    private void closeApplication() {
        try {
            Settings newSettings = this.gatherNewSettings();
            if (Configurator.settingsEqual(newSettings)) {
                System.exit(0);
            }
        }
        catch (ValidationException e) {
            // empty catch block
        }
        int option = JOptionPane.showConfirmDialog(this, "Are you sure you wish to close without saving?\n\n", "Confirm Exit", 0);
        if (option == 0) {
            System.exit(0);
        }
    }

    private Component newTabbedPanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConfiguratorFrame.this.checkForJiraHomeChange();
            }
        });
        tabbedPane.addTab("JIRA Home", this.newJiraHomePanel());
        tabbedPane.addTab("Database", this.newDatabasePanel());
        tabbedPane.addTab("Web Server", this.newWebServerPanel());
        tabbedPane.addTab("Advanced", this.newAdvancedPanel());
        return tabbedPane;
    }

    private JComponent newJiraHomePanel() {
        ConfigPanelBuilder panelBuilder = new ConfigPanelBuilder();
        panelBuilder.add("JIRA Home Directory", this.getJiraHomePicker());
        JPanel panel = panelBuilder.getPanel();
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        return panel;
    }

    private JComponent getJiraHomePicker() {
        JPanel panel = new JPanel(new BorderLayout(4, 0));
        this.tfJiraHome.setToolTipText("Set the 'JIRA Home' directory (used to store data for this JIRA installation)");
        panel.add((Component)this.tfJiraHome, "Center");
        JButton btnJiraHome = new JButton("Browse");
        btnJiraHome.setToolTipText("Opens a dialog box to select the JIRA Home");
        btnJiraHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguratorFrame.this.browseForJiraHome();
            }
        });
        panel.add((Component)btnJiraHome, "East");
        return panel;
    }

    private void browseForJiraHome() {
        JFileChooser chooser = new JFileChooser(this.tfJiraHome.getText());
        chooser.setDialogTitle("JIRA Home directory");
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Directory";
            }
        });
        int returnVal = chooser.showDialog(this, "OK");
        if (returnVal == 0) {
            File parent;
            File jirahome = chooser.getSelectedFile().getAbsoluteFile();
            if (!jirahome.exists() && (parent = jirahome.getParentFile()) != null && parent.exists() && parent.getName().equals(jirahome.getName())) {
                jirahome = parent;
            }
            this.tfJiraHome.setText(jirahome.getPath());
        }
    }

    private JComponent newWebServerPanel() {
        JPanel webServerPanel = new JPanel(new BorderLayout());
        webServerPanel.add((Component)this.initWebServerWarningLabel(), "North");
        webServerPanel.add((Component)this.createWebServerConfigPanel(), "Center");
        webServerPanel.add((Component)this.initTestSslSetupButton(), "South");
        return webServerPanel;
    }

    private JComponent initWebServerWarningLabel() {
        this.tooComplexConfigurationWarning.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
        this.tooComplexConfigurationWarning.setVisible(false);
        this.tooComplexConfigurationWarning.setBorder(new EmptyBorder(4, 4, 10, 4));
        return this.tooComplexConfigurationWarning;
    }

    private void updateWebServerWarningLabel(@Nonnull List<ComplexConfigurationReason> reasons) {
        if (!reasons.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("<html>");
            builder.append("It has been detected, that the current configuration is too complex or partly not supported to offer all options. The following items have been identified:");
            for (ComplexConfigurationReason reason : reasons) {
                builder.append("<br />* ").append(reason.getDescription());
            }
            builder.append("</html>");
            this.tooComplexConfigurationWarning.setText(builder.toString());
        }
        this.tooComplexConfigurationWarning.setVisible(!reasons.isEmpty());
    }

    private JComponent createWebServerConfigPanel() {
        ConfigPanelBuilder panelBuilder = new ConfigPanelBuilder();
        panelBuilder.add("Control Port", this.tfControlPort);
        panelBuilder.add("Profile", this.cbWebServerProfile);
        panelBuilder.add("HTTP Port", this.tfHttpPort);
        panelBuilder.add("HTTPs Port", this.tfHttpsPort);
        panelBuilder.add("Keystore Path", this.createKeyStorePanel());
        panelBuilder.add("Keystore Password", this.tfKeyStorePassword);
        panelBuilder.add("Key Alias", this.tfKeyAlias);
        JPanel panel = panelBuilder.getPanel();
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.initWebServerComboBox();
        return panel;
    }

    private void initWebServerComboBox() {
        WebServerProfile[] allProfiles;
        for (WebServerProfile profile : allProfiles = WebServerProfile.values()) {
            this.cbWebServerProfile.addItem(profile);
        }
    }

    @Nonnull
    private WebServerProfile getWebServerProfile() {
        return (WebServerProfile)((Object)this.cbWebServerProfile.getSelectedItem());
    }

    private void updateWebServerConfigurationFields(@Nonnull WebServerProfile profile) {
        boolean httpEnabled = profile.isHttpEnabled();
        this.tfHttpPort.setEnabled(httpEnabled);
        boolean httpsEnabled = profile.isHttpsEnabled();
        this.tfHttpsPort.setEnabled(httpsEnabled);
        this.tfKeyStorePath.setEnabled(httpsEnabled);
        this.browseKeyStoreButton.setEnabled(httpsEnabled);
        this.tfKeyStorePassword.setEnabled(httpsEnabled);
        this.tfKeyAlias.setEnabled(httpsEnabled);
        this.checkCertificate.setEnabled(httpsEnabled);
    }

    private JComponent createKeyStorePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.tfKeyStorePath, "Center");
        this.browseKeyStoreButton.setToolTipText("Opens a dialog box to select the key store.");
        this.browseKeyStoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguratorFrame.this.browseForKeyStore();
            }
        });
        panel.add((Component)this.browseKeyStoreButton, "East");
        return panel;
    }

    private void browseForKeyStore() {
        JFileChooser chooser = new JFileChooser(this.tfKeyStorePath.getText());
        chooser.setDialogTitle("Keystore Path");
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        int returnVal = chooser.showDialog(this, "OK");
        if (returnVal == 0) {
            File keyStorePath = chooser.getSelectedFile().getAbsoluteFile();
            this.tfKeyStorePath.setText(keyStorePath.getPath());
        }
    }

    private JButton initTestSslSetupButton() {
        this.checkCertificate.setToolTipText("Verifies that the entered values for the HTTPs set up are valid.");
        this.checkCertificate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CertificateDetails certificateDetails = new CertificateDetails(ConfiguratorFrame.this.validateKeyStoreLocation(), ConfiguratorFrame.this.validateKeyStorePassword(), ConfiguratorFrame.this.validateKeyAlias());
                    X509Certificate x509Certificate = ConfiguratorFrame.this.keyStoreAccessor.loadCertificate(certificateDetails);
                    if (x509Certificate != null) {
                        String certificateInformation = CertificatePrettyPrinter.prettyPrint(x509Certificate);
                        ConfiguratorFrame.this.showInformationDialog(String.format("The following certificate was found:%n%n%s%n", certificateInformation));
                    } else {
                        ConfiguratorFrame.this.showErrorDialog("The private key could not be found in the key store.");
                    }
                }
                catch (UnrecoverableEntryException e) {
                    ConfiguratorFrame.this.showErrorDialog("The entered password is valid for the key store, but not for the private key.\nYou need to synchronize both passwords in order to proceed.");
                }
                catch (Exception e) {
                    ConfiguratorFrame.this.showErrorDialog(e);
                }
            }
        });
        return this.checkCertificate;
    }

    private String validateKeyStoreLocation() throws ValidationException {
        return Validator.EXISTING_FILE.apply("Keystore Path", this.tfKeyStorePath.getText());
    }

    private String validateKeyStorePassword() throws ValidationException {
        return Validator.NON_EMTPY_STRING.apply("Keystore Password", this.tfKeyStorePassword.getText());
    }

    private String validateKeyAlias() throws ValidationException {
        return Validator.NON_EMTPY_STRING.apply("Key Alias", this.tfKeyAlias.getText());
    }

    private JComponent newAdvancedPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        JPanel pnlNorth = new JPanel(new VerticalFlowLayout());
        panel.add((Component)pnlNorth, "North");
        pnlNorth.add(this.newAdvancedConfigPanel("Scalability and Performance", ConnectionPoolField.getScalabityAndPerformanceFields()));
        pnlNorth.add(this.newAdvancedConfigPanel("Eviction Policy", ConnectionPoolField.getEvictionPolicyFields()));
        return panel;
    }

    private JPanel newAdvancedConfigPanel(String title, List<ConnectionPoolField> fields) {
        ConfigPanelBuilder panelBuilder = new ConfigPanelBuilder();
        for (ConnectionPoolField field : fields) {
            this.addConnectionPoolField(panelBuilder, field);
        }
        JPanel panel = panelBuilder.getPanel();
        panel.setBorder(new TitledBorder(title));
        return panel;
    }

    private void addConnectionPoolField(ConfigPanelBuilder panelBuilder, ConnectionPoolField field) {
        int len = field.getLengthHint();
        JComponent component = len > 0 ? new JTextField(len) : new JCheckBox();
        component.setToolTipText(field.description());
        this.advancedSettings.put(field, panelBuilder.add(field.label(), component, field.defaultValue()));
    }

    private JComponent newDatabasePanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        JPanel pnlNorth = new JPanel(new VerticalFlowLayout());
        panel.add((Component)pnlNorth, "North");
        this.createDataBaseDropDown();
        ConfigPanelBuilder panelBuilder = new ConfigPanelBuilder();
        panelBuilder.add("Database type", this.ddDatabaseType);
        pnlNorth.add(panelBuilder.getPanel());
        this.createCardPanel();
        pnlNorth.add(this.cardPanel);
        panel.add((Component)this.newTestConnectionButton(), "South");
        return panel;
    }

    private JComponent newTestConnectionButton() {
        JButton button = new JButton("Test Connection");
        button.setToolTipText("Try to connect to the database with these settings");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguratorFrame.this.connectionTestDialog.setText("Attempting to connect to the " + ConfiguratorFrame.this.getSelectedDatabaseConfigPanel().getDisplayName() + " database server...");
                ConfiguratorFrame.this.connectionTestDialog.enableCloseButton(false);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ConfiguratorFrame.this.testConnection();
                    }
                }).start();
                ConfiguratorFrame.this.connectionTestDialog.setVisible(true);
            }
        });
        return button;
    }

    private void testConnection() {
        DatabaseConfigPanel jdbcPanel = this.getSelectedDatabaseConfigPanel();
        String errorMessage = null;
        try {
            jdbcPanel.validate();
            jdbcPanel.testConnection(this.tfJiraHome.getText());
        }
        catch (UnsupportedClassVersionError ex) {
            errorMessage = "UnsupportedClassVersionError occurred. It is likely your JDBC drivers use a newer version of Java than you are running now.";
        }
        catch (ClassNotFoundException ex) {
            errorMessage = StringUtils.join(DatabaseDriverRegisterer.forDriverClass(jdbcPanel.getClassName()).getErrorMessage().iterator(), (String)"\n");
        }
        catch (SQLException ex) {
            String message = ex.getMessage();
            if (message.contains("Stack Trace")) {
                if (message.contains("UnknownHostException")) {
                    message = "Unknown host.";
                } else if (message.contains("Check that the hostname and port are correct")) {
                    message = "Check that the hostname and port are correct.";
                }
            }
            errorMessage = "Could not connect to the DB: " + message;
        }
        catch (ValidationException ex) {
            errorMessage = ex.getMessage();
        }
        catch (RuntimeException ex) {
            errorMessage = "An unexpected error occurred: " + ex.getMessage();
            System.err.println(errorMessage);
            ex.printStackTrace(System.err);
        }
        class SwingRunner
        implements Runnable {
            private String errorMessage;

            SwingRunner(String errorMessage) {
                this.errorMessage = errorMessage;
            }

            @Override
            public void run() {
                if (this.errorMessage == null) {
                    ConfiguratorFrame.this.connectionTestDialog.addText("Connection successful.");
                } else {
                    ConfiguratorFrame.this.connectionTestDialog.addText(this.errorMessage);
                }
                ConfiguratorFrame.this.connectionTestDialog.enableCloseButton(true);
            }
        }
        SwingUtilities.invokeLater(new SwingRunner(errorMessage));
    }

    private DatabaseConfigPanel getSelectedDatabaseConfigPanel() {
        return this.getDatabaseConfigPanel(this.getSelectedDatabaseType());
    }

    private DatabaseType getSelectedDatabaseType() {
        return (DatabaseType)((Object)this.ddDatabaseType.getSelectedItem());
    }

    private void createCardPanel() {
        this.cardPanel = new JPanel();
        this.jdbcTypeCardLayout = new CardLayout();
        this.cardPanel.setLayout(this.jdbcTypeCardLayout);
        this.cardPanel.setBorder(new TitledBorder("Connection Details"));
        for (DatabaseType databaseType : DatabaseType.knownTypes()) {
            this.cardPanel.add((Component)this.getDatabaseConfigPanel(databaseType).getPanel(), databaseType.getDisplayName());
        }
    }

    private DatabaseConfigPanel getDatabaseConfigPanel(DatabaseType databaseType) {
        if (this.configPanelMap == null) {
            this.configPanelMap = new HashMap<DatabaseType, DatabaseConfigPanel>(5);
            this.configPanelMap.put(DatabaseType.HSQL, new HsqlConfigPanel());
            this.configPanelMap.put(DatabaseType.SQL_SERVER, new SqlServerConfigPanel());
            this.configPanelMap.put(DatabaseType.MY_SQL, new MySqlConfigPanel());
            this.configPanelMap.put(DatabaseType.ORACLE, new OracleConfigPanel());
            this.configPanelMap.put(DatabaseType.POSTGRES, new PostgresConfigPanel());
        }
        return this.configPanelMap.get((Object)databaseType);
    }

    private void createDataBaseDropDown() {
        this.ddDatabaseType = new JComboBox<DatabaseType>(DatabaseType.values());
        this.ddDatabaseType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseType databaseType = ConfiguratorFrame.this.getSelectedDatabaseType();
                if (databaseType == null) {
                    return;
                }
                ConfiguratorFrame.this.jdbcTypeCardLayout.show(ConfiguratorFrame.this.cardPanel, databaseType.getDisplayName());
            }
        });
    }

    private JPanel newButtonPanel() {
        JPanel panel = new JPanel();
        panel.add(this.newSaveButton());
        panel.add(this.newCloseButton());
        return panel;
    }

    private Component newSaveButton() {
        JButton button = new JButton("Save");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ConfiguratorFrame.this.checkForJiraHomeChange();
                    Configurator.saveSettings(ConfiguratorFrame.this.gatherNewSettings());
                    ConfiguratorFrame.this.showInformationDialog("Settings saved successfully.");
                }
                catch (ValidationException ex) {
                    ConfiguratorFrame.this.showErrorDialog(ex);
                }
                catch (IOException ex) {
                    ConfiguratorFrame.this.showErrorDialog(ex);
                }
                catch (ParseException ex) {
                    ConfiguratorFrame.this.showErrorDialog((Exception)((Object)ex));
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                    ConfiguratorFrame.this.showErrorDialog("Unexpected error during save:\n" + ex.getMessage());
                }
            }
        });
        return button;
    }

    private Settings gatherNewSettings() throws ValidationException {
        Settings newSettings = new Settings();
        String jiraHome = this.tfJiraHome.getText();
        newSettings.setJiraHome(jiraHome);
        this.getSelectedDatabaseConfigPanel().saveSettings(newSettings, jiraHome);
        this.saveWebServerSettings(newSettings);
        this.gatherAdvancedSettings(newSettings);
        newSettings.getJdbcDatasourceBuilder().setConnectionPoolInfo(null);
        return newSettings;
    }

    private void saveWebServerSettings(@Nonnull Settings newSettings) throws ValidationException {
        newSettings.setControlPort(this.gatherControlPort());
        WebServerProfile selectedWebServerProfile = this.getWebServerProfile();
        String httpPort = this.gatherHttpPort(selectedWebServerProfile);
        SslSettings sslSettings = this.gatherSslSettings(selectedWebServerProfile);
        newSettings.updateWebServerConfiguration(httpPort, sslSettings);
    }

    private String gatherControlPort() throws ValidationException {
        String controlPort = this.tfControlPort.getText().trim();
        Integer validatedControlPort = this.validatePort("Control Port", controlPort);
        return validatedControlPort.toString();
    }

    private String gatherHttpPort(@Nonnull WebServerProfile profile) throws ValidationException {
        if (profile.isHttpEnabled()) {
            String httpPort = this.tfHttpPort.getText().trim();
            Integer validatedHttpPort = this.validatePort("HTTP Port", httpPort);
            return validatedHttpPort.toString();
        }
        return null;
    }

    private SslSettings gatherSslSettings(@Nonnull WebServerProfile profile) throws ValidationException {
        if (profile.isHttpsEnabled()) {
            Integer httpsPort = this.validatePort("HTTPs Port", this.tfHttpsPort.getText());
            String keyStoreLocation = this.validateKeyStoreLocation();
            String keyStorePassword = this.validateKeyStorePassword();
            String keyAlias = this.validateKeyAlias();
            return new SslSettings(httpsPort.toString(), keyStoreLocation, keyStorePassword, "JKS", keyAlias);
        }
        return null;
    }

    private Integer validatePort(String fieldName, String port) throws ValidationException {
        return Validator.PORT.apply(fieldName, port);
    }

    private Component newCloseButton() {
        JButton button = new JButton("Close");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguratorFrame.this.closeApplication();
            }
        });
        return button;
    }

    public void setSettings(Settings settings) throws ParseException {
        this.tfJiraHome.setText(settings.getJiraHome());
        this.previousJiraHome = settings.getJiraHome();
        this.ddDatabaseType.setSelectedItem((Object)settings.initDatabaseType(false));
        this.getSelectedDatabaseConfigPanel().setSettings(settings);
        WebServerProfile webServerProfile = settings.getWebServerProfile();
        this.tfControlPort.setText(settings.getControlPort());
        this.updateWebServerProfile(settings);
        if (webServerProfile.isHttpEnabled()) {
            this.tfHttpPort.setText(settings.getHttpPort());
        }
        SslSettings sslSettings = settings.getSslSettings();
        if (webServerProfile.isHttpsEnabled() && sslSettings != null) {
            this.tfHttpsPort.setText(sslSettings.getHttpsPort());
            this.tfKeyStorePath.setText(sslSettings.getKeystoreFile());
            this.tfKeyStorePassword.setText(sslSettings.getKeystorePass());
            this.tfKeyAlias.setText(sslSettings.getKeyAlias());
        }
        this.updateWebServerConfigurationFields(webServerProfile);
        this.initAdvancedSettings(settings);
    }

    private void updateWebServerProfile(final @Nonnull Settings settings) {
        final List<WebServerProfile> usableProfiles = WebServerProfile.getUsableProfiles(settings);
        this.cbWebServerProfile.setRenderer(new DisabledComboBoxRenderer(usableProfiles));
        this.cbWebServerProfile.setSelectedItem((Object)settings.getWebServerProfile());
        this.cbWebServerProfile.setAction(new AbstractAction(){
            private WebServerProfile currentProfile;
            private List<WebServerProfile> usableProfile;
            {
                this.currentProfile = settings.getWebServerProfile();
                this.usableProfile = usableProfiles;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebServerProfile selectedProfile = ConfiguratorFrame.this.getWebServerProfile();
                if (this.usableProfile.contains((Object)selectedProfile)) {
                    this.currentProfile = selectedProfile;
                    ConfiguratorFrame.this.updateWebServerConfigurationFields(selectedProfile);
                } else {
                    ConfiguratorFrame.this.cbWebServerProfile.setSelectedItem((Object)this.currentProfile);
                }
            }
        });
        this.updateWebServerWarningLabel(settings.getComplexConfigurationReasons());
    }

    private void showErrorDialog(Exception ex) {
        this.showErrorDialog(ex.getMessage());
    }

    private void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    private void showInformationDialog(String message) {
        JOptionPane.showMessageDialog(this, message, "Information", 1);
    }

    private void initAdvancedSettings(Settings settings) {
        ConnectionPoolInfo.Builder poolInfo = settings.getConnectionPoolInfoBuilder();
        this.advancedSettings.get((Object)ConnectionPoolField.MAX_SIZE).setValue(poolInfo.getPoolMaxSize());
        this.advancedSettings.get((Object)ConnectionPoolField.MAX_IDLE).setValue(poolInfo.getPoolMaxIdle());
        this.advancedSettings.get((Object)ConnectionPoolField.MIN_SIZE).setValue(poolInfo.getPoolMinSize());
        this.advancedSettings.get((Object)ConnectionPoolField.INITIAL_SIZE).setValue(poolInfo.getPoolInitialSize());
        this.advancedSettings.get((Object)ConnectionPoolField.MAX_WAIT).setValue(poolInfo.getPoolMaxWait());
        this.advancedSettings.get((Object)ConnectionPoolField.POOL_STATEMENTS).setValue(poolInfo.getPoolPreparedStatements());
        this.advancedSettings.get((Object)ConnectionPoolField.MAX_OPEN_STATEMENTS).setValue(poolInfo.getMaxOpenPreparedStatements());
        this.advancedSettings.get((Object)ConnectionPoolField.VALIDATION_QUERY).setValue(poolInfo.getValidationQuery());
        this.advancedSettings.get((Object)ConnectionPoolField.VALIDATION_QUERY_TIMEOUT).setValue(poolInfo.getValidationQueryTimeout());
        this.advancedSettings.get((Object)ConnectionPoolField.TEST_ON_BORROW).setValue(poolInfo.getTestOnBorrow());
        this.advancedSettings.get((Object)ConnectionPoolField.TEST_ON_RETURN).setValue(poolInfo.getTestOnReturn());
        this.advancedSettings.get((Object)ConnectionPoolField.TEST_WHILE_IDLE).setValue(poolInfo.getTestWhileIdle());
        this.advancedSettings.get((Object)ConnectionPoolField.TIME_BETWEEN_EVICTION_RUNS).setValue(poolInfo.getTimeBetweenEvictionRunsMillis());
        this.advancedSettings.get((Object)ConnectionPoolField.MIN_EVICTABLE_IDLE_TIME).setValue(poolInfo.getMinEvictableTimeMillis());
        this.advancedSettings.get((Object)ConnectionPoolField.REMOVE_ABANDONED).setValue(poolInfo.getRemoveAbandoned());
        this.advancedSettings.get((Object)ConnectionPoolField.REMOVE_ABANDONED_TIMEOUT).setValue(poolInfo.getRemoveAbandonedTimeout());
    }

    private <T> T gatherAdvancedSetting(ConnectionPoolField field, Validator<T> validator) throws ValidationException {
        LabelledComponent component = this.advancedSettings.get((Object)field);
        return validator.apply(component.label(), component.getValue());
    }

    private ConnectionPoolInfo.Builder verifyAdvancedSettings() throws ValidationException {
        ConnectionPoolInfo.Builder poolInfo = ConnectionPoolInfo.builder();
        poolInfo.setPoolMaxSize(this.gatherAdvancedSetting(ConnectionPoolField.MAX_SIZE, Validator.INTEGER_POSITIVE));
        poolInfo.setPoolMaxIdle(this.gatherAdvancedSetting(ConnectionPoolField.MAX_IDLE, Validator.INTEGER_ALLOW_MINUS_1));
        poolInfo.setPoolMinSize(this.gatherAdvancedSetting(ConnectionPoolField.MIN_SIZE, Validator.INTEGER_POSITIVE_OR_ZERO));
        poolInfo.setPoolInitialSize(this.gatherAdvancedSetting(ConnectionPoolField.INITIAL_SIZE, Validator.INTEGER_POSITIVE_OR_ZERO));
        poolInfo.setPoolMaxWait(this.gatherAdvancedSetting(ConnectionPoolField.MAX_WAIT, Validator.LONG_ALLOW_MINUS_1));
        poolInfo.setPoolPreparedStatements(this.gatherAdvancedSetting(ConnectionPoolField.POOL_STATEMENTS, Validator.BOOLEAN));
        poolInfo.setMaxOpenPreparedStatements(this.gatherAdvancedSetting(ConnectionPoolField.MAX_OPEN_STATEMENTS, Validator.INTEGER_ALLOW_MINUS_1));
        poolInfo.setValidationQuery(this.gatherAdvancedSetting(ConnectionPoolField.VALIDATION_QUERY, Validator.TRIMMED_STRING));
        poolInfo.setValidationQueryTimeout(this.gatherAdvancedSetting(ConnectionPoolField.VALIDATION_QUERY_TIMEOUT, Validator.INTEGER_ALLOW_MINUS_1));
        poolInfo.setTestOnBorrow(this.gatherAdvancedSetting(ConnectionPoolField.TEST_ON_BORROW, Validator.BOOLEAN));
        poolInfo.setTestOnReturn(this.gatherAdvancedSetting(ConnectionPoolField.TEST_ON_RETURN, Validator.BOOLEAN));
        poolInfo.setTestWhileIdle(this.gatherAdvancedSetting(ConnectionPoolField.TEST_WHILE_IDLE, Validator.BOOLEAN));
        poolInfo.setTimeBetweenEvictionRunsMillis(this.gatherAdvancedSetting(ConnectionPoolField.TIME_BETWEEN_EVICTION_RUNS, Validator.LONG_ALLOW_MINUS_1));
        poolInfo.setMinEvictableTimeMillis(this.gatherAdvancedSetting(ConnectionPoolField.MIN_EVICTABLE_IDLE_TIME, Validator.LONG_POSITIVE));
        poolInfo.setRemoveAbandoned(this.gatherAdvancedSetting(ConnectionPoolField.REMOVE_ABANDONED, Validator.BOOLEAN));
        poolInfo.setRemoveAbandonedTimeout(this.gatherAdvancedSetting(ConnectionPoolField.REMOVE_ABANDONED_TIMEOUT, Validator.INTEGER_POSITIVE));
        return poolInfo;
    }

    private void gatherAdvancedSettings(Settings settings) throws ValidationException {
        settings.setConnectionPoolInfoBuilder(this.verifyAdvancedSettings());
        this.initAdvancedSettings(settings);
    }

    private void checkForJiraHomeChange() {
        String newJiraHome = this.tfJiraHome.getText().trim();
        if (!newJiraHome.equals(this.previousJiraHome)) {
            int option;
            File configFile = new File(newJiraHome, "dbconfig.xml");
            if (configFile.exists() && (option = JOptionPane.showConfirmDialog(this, "Would you like to reload the DB configuration from the new JIRA Home?", "Reload DB Config", 0, 3)) == 0) {
                try {
                    Settings settings = SettingsLoader.reloadDbConfig(newJiraHome);
                    this.ddDatabaseType.setSelectedItem((Object)settings.initDatabaseType(false));
                    this.getSelectedDatabaseConfigPanel().setSettings(settings);
                    this.initAdvancedSettings(settings);
                }
                catch (IOException ex) {
                    this.showErrorDialog(ex);
                }
                catch (ParseException ex) {
                    this.showErrorDialog((Exception)((Object)ex));
                }
            }
            this.previousJiraHome = newJiraHome.trim();
        }
    }
}

