/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureDisabledEvent;
import com.atlassian.jira.config.FeatureEnabledEvent;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureManager
implements FeatureManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultFeatureManager.class);
    private static final String USER_DARKFEATURE_PREFERENCE_KEY = "user.features.enabled";
    private static final boolean DARK_FEATURES_DISABLED_SYSTEM_WIDE = Boolean.getBoolean("atlassian.darkfeature.disabled");
    public static final String FEATURE_RESOURCE_TYPE = "feature";
    public static final Resources.TypeFilter FEATURE_TYPE_FILTER = new Resources.TypeFilter("feature");
    private static final String CORE_FEATURES_RESOURCE = "jira-features.properties";
    private static final Function<String, InputStream> APP_CLASS_LOADER = new Function<String, InputStream>(){

        public InputStream apply(@Nullable String name) {
            return DefaultFeatureManager.class.getClassLoader().getResourceAsStream(name);
        }
    };
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext authenticationContext;
    private final UserPreferencesManager userPreferencesManager;
    private final EventPublisher eventPublisher;
    private final FeaturesMapHolder features;

    private static Function<String, InputStream> pluginLoader(final Plugin plugin) {
        return new Function<String, InputStream>(){

            public InputStream apply(@Nullable String name) {
                return plugin.getResourceAsStream(name);
            }
        };
    }

    @VisibleForTesting
    DefaultFeatureManager(PropertiesContainer properties, EventPublisher eventPublisher, PermissionManager permissionManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, UserPreferencesManager userPreferencesManager) {
        this.eventPublisher = eventPublisher;
        this.features = new FeaturesMapHolder(properties.properties);
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.userPreferencesManager = userPreferencesManager;
    }

    public DefaultFeatureManager(PluginAccessor pluginAccessor, EventPublisher eventPublisher, PermissionManager permissionManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, UserPreferencesManager userPreferencesManager) {
        this.eventPublisher = eventPublisher;
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.userPreferencesManager = userPreferencesManager;
        this.features = new FeaturesMapHolder(pluginAccessor);
        eventPublisher.register((Object)this.features);
    }

    private static Properties loadCoreProperties() {
        Properties properties = DefaultFeatureManager.loadProperties(CORE_FEATURES_RESOURCE, APP_CLASS_LOADER);
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith("atlassian.darkfeature.")) continue;
            String featureKey = key.substring("atlassian.darkfeature.".length(), key.length());
            String featureValue = System.getProperty(key);
            log.trace("Feature '{}' is set to {} by system properties", (Object)featureKey, (Object)featureValue);
            properties.setProperty(featureKey, featureValue);
        }
        return properties;
    }

    private static Properties loadProperties(String path, Function<String, InputStream> loader) {
        InputStream propsStream = (InputStream)Preconditions.checkNotNull((Object)loader.apply((Object)path), (Object)String.format("Resource %s not found", path));
        try {
            Properties props = new Properties();
            props.load(propsStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load properties from " + path, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)propsStream);
        }
    }

    @Override
    public boolean isEnabled(String featureKey) {
        boolean enabled = Boolean.TRUE.equals(this.features.features().get((Object)featureKey));
        if (!enabled) {
            enabled = this.getDarkFeatures().isFeatureEnabled(featureKey);
        }
        return enabled;
    }

    @Override
    public boolean isEnabled(CoreFeatures coreFeature) {
        return this.isEnabled(coreFeature.featureKey());
    }

    @Override
    public Set<String> getEnabledFeatureKeys() {
        return this.features.enabledFeatures();
    }

    @Override
    public DarkFeatures getDarkFeatures() {
        if (DARK_FEATURES_DISABLED_SYSTEM_WIDE) {
            return new DarkFeatures(Collections.<String>emptySet(), Collections.<String>emptySet(), Collections.<String>emptySet());
        }
        User user = this.authenticationContext.getLoggedInUser();
        return new DarkFeatures(this.getEnabledFeatureKeys(), this.getSiteEnabledFeatures(), this.getUserEnabledFeatures(user));
    }

    @Override
    public void enableUserDarkFeature(User user, String feature) {
        this.changeUserDarkFeature(user, feature, true);
    }

    @Override
    public void disableUserDarkFeature(User user, String feature) {
        this.changeUserDarkFeature(user, feature, false);
    }

    @Override
    public void enableSiteDarkFeature(String feature) {
        this.changeSiteDarkFeature(feature, true);
    }

    @Override
    public void disableSiteDarkFeature(String feature) {
        this.changeSiteDarkFeature(feature, false);
    }

    @Override
    public boolean hasSiteEditPermission() {
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        return this.permissionManager.hasPermission(0, loggedInUser);
    }

    private void changeUserDarkFeature(User user, String feature, boolean enable) {
        try {
            CoreFeatures coreFeature = CoreFeatures.valueOf(feature);
            if (coreFeature != null && !coreFeature.isDevFeature()) {
                throw new IllegalStateException("User cannot set feature '" + feature + "' at runtime. It must be set by an admin via properties.");
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        HashSet enabledFeatures = Sets.newHashSet(this.getUserEnabledFeatures(user));
        if (enable == enabledFeatures.contains(feature)) {
            return;
        }
        if (enable) {
            enabledFeatures.add(feature);
        } else {
            enabledFeatures.remove(feature);
        }
        try {
            Preferences prefs = this.userPreferencesManager.getPreferences(user);
            prefs.setString(USER_DARKFEATURE_PREFERENCE_KEY, DefaultFeatureManager.serialize(enabledFeatures));
        }
        catch (AtlassianCoreException e) {
            throw new IllegalStateException(e);
        }
        this.eventPublisher.publish(enable ? new FeatureEnabledEvent(feature, user) : new FeatureDisabledEvent(feature, user));
    }

    private void changeSiteDarkFeature(String feature, boolean enable) {
        if (!this.hasSiteEditPermission()) {
            throw new IllegalStateException("User " + this.authenticationContext.getLoggedInUser() + " does not have permission to change site dark features");
        }
        Set<String> enabledFeatures = this.getSiteEnabledFeatures();
        if (enable == enabledFeatures.contains(feature)) {
            return;
        }
        if (enable) {
            enabledFeatures.add(feature);
        } else {
            enabledFeatures.remove(feature);
        }
        this.applicationProperties.setString("jira.enabled.dark.features", DefaultFeatureManager.serialize(enabledFeatures));
        this.eventPublisher.publish(enable ? new FeatureEnabledEvent(feature) : new FeatureDisabledEvent(feature));
    }

    private static String serialize(Set<String> features) {
        return StringUtils.join(features, (String)",");
    }

    private static Set<String> deserialize(String features) {
        if (StringUtils.isBlank((String)features)) {
            return Sets.newHashSet();
        }
        Object[] featureKeys = features.split(",");
        return Sets.newHashSet((Object[])featureKeys);
    }

    private Set<String> getUserEnabledFeatures(User user) {
        Preferences preferences = this.userPreferencesManager.getPreferences(user);
        String features = preferences.getString(USER_DARKFEATURE_PREFERENCE_KEY);
        return DefaultFeatureManager.deserialize(features);
    }

    private Set<String> getSiteEnabledFeatures() {
        String features = this.applicationProperties.getString("jira.enabled.dark.features");
        return DefaultFeatureManager.deserialize(features);
    }

    private static List<Properties> loadPluginFeatureProperties(PluginAccessor pluginAccessor) {
        ArrayList features = Lists.newArrayList();
        for (Plugin plugin : pluginAccessor.getEnabledPlugins()) {
            for (ResourceDescriptor featureDescriptor : DefaultFeatureManager.getFeatureResources(plugin)) {
                features.add(DefaultFeatureManager.loadProperties(featureDescriptor.getLocation(), DefaultFeatureManager.pluginLoader(plugin)));
            }
        }
        return features;
    }

    private static Collection<ResourceDescriptor> getFeatureResources(Plugin plugin) {
        return Collections2.filter((Collection)plugin.getResourceDescriptors(), (Predicate)FEATURE_TYPE_FILTER);
    }

    @VisibleForTesting
    static final class PropertiesContainer {
        final Iterable<Properties> properties;

        PropertiesContainer(Iterable<Properties> properties) {
            this.properties = properties;
        }
    }

    public static class FeaturesMapHolder {
        private final ResettableLazyReference<ImmutableMap<String, Boolean>> features;
        private final ResettableLazyReference<ImmutableSet<String>> enabledFeatures = new EnabledFeaturesRef();

        FeaturesMapHolder(final PluginAccessor pluginAccessor) {
            this.features = new ResettableLazyReference<ImmutableMap<String, Boolean>>(){

                protected ImmutableMap<String, Boolean> create() throws Exception {
                    return FeaturesMapHolder.this.initFeatures(Iterables.concat((Iterable)ImmutableList.of((Object)DefaultFeatureManager.loadCoreProperties()), (Iterable)DefaultFeatureManager.loadPluginFeatureProperties(pluginAccessor)));
                }
            };
        }

        FeaturesMapHolder(final Iterable<Properties> properties) {
            this.features = new ResettableLazyReference<ImmutableMap<String, Boolean>>(){

                protected ImmutableMap<String, Boolean> create() throws Exception {
                    return FeaturesMapHolder.this.initFeatures(properties);
                }
            };
        }

        ImmutableMap<String, Boolean> features() {
            return (ImmutableMap)this.features.get();
        }

        ImmutableSet<String> enabledFeatures() {
            return (ImmutableSet)this.enabledFeatures.get();
        }

        private ImmutableMap<String, Boolean> initFeatures(Iterable<Properties> properties) {
            HashMap collector = Maps.newHashMap();
            for (Properties singleProperties : properties) {
                for (String property : singleProperties.stringPropertyNames()) {
                    collector.put(property, Boolean.valueOf(singleProperties.getProperty(property)));
                }
            }
            return ImmutableMap.copyOf((Map)collector);
        }

        private ImmutableSet<String> initEnabledFeatures(ImmutableMap<String, Boolean> allFeatures) {
            ImmutableSet.Builder collector = ImmutableSet.builder();
            for (Map.Entry featureToggle : allFeatures.entrySet()) {
                if (!((Boolean)featureToggle.getValue()).booleanValue()) continue;
                collector.add(featureToggle.getKey());
            }
            return collector.build();
        }

        @EventListener
        public void onPluginEnabled(PluginEnabledEvent event) {
            this.onPluginEvent(event.getPlugin());
        }

        @EventListener
        public void onPluginDisabled(PluginDisabledEvent event) {
            this.onPluginEvent(event.getPlugin());
        }

        private void onPluginEvent(Plugin plugin) {
            if (!DefaultFeatureManager.getFeatureResources(plugin).isEmpty()) {
                this.features.reset();
                this.enabledFeatures.reset();
            }
        }

        private class EnabledFeaturesRef
        extends ResettableLazyReference<ImmutableSet<String>> {
            private EnabledFeaturesRef() {
            }

            protected ImmutableSet<String> create() throws Exception {
                return FeaturesMapHolder.this.initEnabledFeatures((ImmutableMap<String, Boolean>)((ImmutableMap)FeaturesMapHolder.this.features.get()));
            }
        }
    }
}

