/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.config;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultConstantsService
implements ConstantsService {
    private final I18nHelper.BeanFactory i18n;
    private final ConstantsManager constantsMgr;
    private final PermissionManager permissionMgr;
    private final WorkflowSchemeManager workflowSchemeMgr;
    private final WorkflowManager workflowMgr;
    private final IssueTypeSchemeManager issueTypeSchemeMgr;

    public DefaultConstantsService(I18nHelper.BeanFactory i18n, ConstantsManager constantsManager, PermissionManager permissionManager, WorkflowSchemeManager workflowSchemeMgr, WorkflowManager workflowMgr, IssueTypeSchemeManager issueTypeSchemeMgr) {
        this.constantsMgr = constantsManager;
        this.permissionMgr = permissionManager;
        this.workflowSchemeMgr = workflowSchemeMgr;
        this.workflowMgr = workflowMgr;
        this.i18n = i18n;
        this.issueTypeSchemeMgr = issueTypeSchemeMgr;
    }

    public ServiceOutcome<Status> getStatusById(User user, String statusId) {
        Status status = this.constantsMgr.getStatusObject(statusId);
        if (status != null && this.isStatusVisible(user, status)) {
            return ServiceOutcomeImpl.ok(status);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.not.found", statusId));
    }

    public ServiceOutcome<Status> getStatusByName(User user, String statusName) {
        Status status = this.constantsMgr.getStatusByName(statusName);
        if (status != null && this.isStatusVisible(user, status)) {
            return ServiceOutcomeImpl.ok(status);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.not.found", statusName));
    }

    public ServiceOutcome<Status> getStatusByTranslatedName(User user, String statusName) {
        Status status = this.constantsMgr.getStatusByTranslatedName(statusName);
        if (status != null && this.isStatusVisible(user, status)) {
            return ServiceOutcomeImpl.ok(status);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.not.found", statusName));
    }

    private boolean isStatusVisible(User user, Status status) {
        Collection visibleProjects = this.permissionMgr.getProjectObjects(10, user);
        for (Project project : visibleProjects) {
            List<JiraWorkflow> workflows = this.getWorkflows(project);
            for (JiraWorkflow workflow : workflows) {
                List steps = workflow.getDescriptor().getSteps();
                for (StepDescriptor step : steps) {
                    String linkedStatusId = (String)step.getMetaAttributes().get("jira.status.id");
                    if (!status.getId().equals(linkedStatusId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public ServiceOutcome<Collection<Status>> getAllStatuses(User user) {
        ArrayList<Status> visibleStatuses = new ArrayList<Status>();
        Collection statuses = this.constantsMgr.getStatusObjects();
        for (Status status : statuses) {
            if (!this.isStatusVisible(user, status)) continue;
            visibleStatuses.add(status);
        }
        return ServiceOutcomeImpl.ok(visibleStatuses);
    }

    public ServiceOutcome<Collection<IssueType>> getAllIssueTypes(User user) {
        HashSet<IssueType> visibleIssueTypes = new HashSet<IssueType>();
        Collection visibleProjects = this.permissionMgr.getProjectObjects(10, user);
        for (Project project : visibleProjects) {
            for (IssueType visibleType : this.issueTypeSchemeMgr.getIssueTypesForProject(project)) {
                visibleIssueTypes.add(visibleType);
            }
        }
        return ServiceOutcomeImpl.ok(visibleIssueTypes);
    }

    public ServiceOutcome<IssueType> getIssueTypeById(User user, String issueTypeId) {
        IssueType issueType = this.constantsMgr.getIssueTypeObject(issueTypeId);
        if (issueType != null) {
            Collection visibleProjects = this.permissionMgr.getProjectObjects(10, user);
            for (Project project : visibleProjects) {
                for (IssueType visibleType : this.issueTypeSchemeMgr.getIssueTypesForProject(project)) {
                    if (!issueTypeId.equals(visibleType.getId())) continue;
                    return ServiceOutcomeImpl.ok(issueType);
                }
            }
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.issuetype.not.found", issueTypeId));
    }

    private List<JiraWorkflow> getWorkflows(Project project) {
        try {
            GenericValue workflowScheme = this.workflowSchemeMgr.getWorkflowScheme(project.getGenericValue());
            if (workflowScheme == null) {
                return Collections.singletonList(this.workflowMgr.getDefaultWorkflow());
            }
            ArrayList<GenericValue> workflows = new ArrayList<GenericValue>();
            GenericValue defaultEntity = this.workflowSchemeMgr.getDefaultEntity(workflowScheme);
            if (defaultEntity != null) {
                workflows.add(defaultEntity);
            }
            workflows.addAll(this.workflowSchemeMgr.getNonDefaultEntities(workflowScheme));
            if (workflows.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<JiraWorkflow> result = new ArrayList<JiraWorkflow>(workflows.size());
            for (GenericValue workflow : workflows) {
                result.add(this.workflowMgr.getWorkflow(workflow.getString("workflow")));
            }
            return result;
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }
}

