/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.function.misc;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreateCommentFunction
implements FunctionProvider {
    private static final Logger log = Logger.getLogger(CreateCommentFunction.class);

    public void execute(Map transientVars, Map args, PropertySet ps) {
        try {
            String commentBody = (String)transientVars.get("comment");
            String groupLevel = (String)transientVars.get("commentLevel");
            String roleLevel = (String)transientVars.get("roleLevel");
            Long roleLevelId = null;
            if (TextUtils.stringSet((String)roleLevel)) {
                roleLevelId = Long.valueOf(roleLevel);
            }
            Issue issue = (Issue)transientVars.get("issue");
            if (TextUtils.stringSet((String)commentBody)) {
                CommentManager commentManager = ComponentManager.getComponentInstanceOfType(CommentManager.class);
                String author = WorkflowUtil.getCallerName((Map)transientVars);
                Comment comment = commentManager.create(issue, author, commentBody, groupLevel, roleLevelId, false);
                transientVars.put("commentValue", comment);
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e), (Throwable)e);
        }
    }

    public static FunctionDescriptor makeDescriptor() {
        FunctionDescriptor descriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
        descriptor.setType("class");
        descriptor.getArgs().put("class.name", CreateCommentFunction.class.getName());
        return descriptor;
    }
}

