/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.workflow.WorkflowScheme;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

abstract class WorkflowSchemeBuilderTemplate<T extends WorkflowScheme.Builder<T>>
implements WorkflowScheme.Builder<T> {
    private final Long id;
    private String name;
    private String description;
    private Map<String, String> mappings;

    WorkflowSchemeBuilderTemplate() {
        this.id = null;
        this.mappings = Maps.newHashMap();
    }

    WorkflowSchemeBuilderTemplate(WorkflowScheme scheme) {
        this.id = scheme.getId();
        this.name = scheme.getName();
        this.description = scheme.getDescription();
        this.mappings = Maps.newHashMap((Map)scheme.getMappings());
    }

    @Nonnull
    public T setName(@Nonnull String name) {
        this.name = StringUtils.stripToNull((String)name);
        return this.builder();
    }

    @Nonnull
    public T setDescription(String description) {
        this.description = StringUtils.stripToNull((String)description);
        return this.builder();
    }

    @Nonnull
    public T setDefaultWorkflow(@Nonnull String workflowName) {
        this.mappings.put(null, workflowName);
        return this.builder();
    }

    @Nonnull
    public T setMapping(@Nonnull String issueTypeId, @Nonnull String workflowName) {
        this.mappings.put(issueTypeId, workflowName);
        return this.builder();
    }

    @Nonnull
    public T setMappings(@Nonnull Map<String, String> mappings) {
        this.mappings = Maps.newHashMap(mappings);
        return this.builder();
    }

    @Nonnull
    public T removeMapping(@Nonnull String issueTypeId) {
        this.mappings.remove(issueTypeId);
        return this.builder();
    }

    @Nonnull
    public T removeDefault() {
        this.mappings.remove(null);
        return this.builder();
    }

    @Nonnull
    public T clearMappings() {
        this.mappings.clear();
        return this.builder();
    }

    String getDescription() {
        return this.description;
    }

    Long getId() {
        return this.id;
    }

    Map<String, String> getMappings() {
        return this.mappings;
    }

    String getName() {
        return this.name;
    }

    abstract T builder();
}

