/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.DraftWorkflowSchemeStore;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class OfBizDraftWorkflowSchemeStore
implements DraftWorkflowSchemeStore {
    private static final String ALL_ISSUE_TYPES = "0";
    private final OfBizDelegator delegator;

    public OfBizDraftWorkflowSchemeStore(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public DraftWorkflowSchemeStore.DraftWorkflowSchemeState create(DraftWorkflowSchemeStore.DraftWorkflowSchemeState state) {
        Assertions.notNull((String)"state", (Object)state);
        Assertions.notNull((String)"state.parentWorkflowId", (Object)state.getParentSchemeId());
        FieldMap fieldMap = FieldMap.build((String)"name", (Object)state.getName());
        fieldMap.add("description", (Object)state.getDescription());
        fieldMap.add("workflowSchemeId", (Object)state.getParentSchemeId());
        fieldMap.add("lastModifiedDate", (Object)OfBizDraftWorkflowSchemeStore.currentDate());
        fieldMap.add("lastModifiedUser", (Object)state.getLastModifiedUser());
        GenericValue schemeGv = this.delegator.createValue("DraftWorkflowScheme", (Map)fieldMap);
        ArrayList mappingGvs = Lists.newArrayList();
        Long newId = schemeGv.getLong("id");
        for (Map.Entry<String, String> mapping : state.getMappings().entrySet()) {
            mappingGvs.add(this.createMapping(newId, mapping.getKey(), mapping.getValue()));
        }
        return this.createStateFrom(schemeGv, mappingGvs);
    }

    @Override
    public DraftWorkflowSchemeStore.DraftWorkflowSchemeState update(DraftWorkflowSchemeStore.DraftWorkflowSchemeState state) {
        Assertions.notNull((String)"state", (Object)state);
        Assertions.notNull((String)"state.id", (Object)state);
        GenericValue schemeGv = this.delegator.findByPrimaryKey("DraftWorkflowScheme", state.getId());
        if (schemeGv == null) {
            throw new DataAccessException("Trying to update draft workflow scheme that does not exist.");
        }
        Long parentId = schemeGv.getLong("workflowSchemeId");
        if (parentId == null || !parentId.equals(state.getParentSchemeId())) {
            throw new DataAccessException("Trying to change the parent of a draft.");
        }
        schemeGv.setString("name", state.getName());
        schemeGv.setString("description", state.getDescription());
        schemeGv.set("lastModifiedDate", (Object)OfBizDraftWorkflowSchemeStore.currentDate());
        schemeGv.set("lastModifiedUser", (Object)state.getLastModifiedUser());
        this.delegator.store(schemeGv);
        List related = this.delegator.getRelated("ChildDraftWorkflowSchemeEntity", schemeGv);
        HashMap schemeMap = Maps.newHashMapWithExpectedSize((int)related.size());
        for (GenericValue value : related) {
            String issueType = value.getString("issuetype");
            if (issueType == null) {
                this.delegator.removeValue(value);
                continue;
            }
            if (ALL_ISSUE_TYPES.equals(issueType)) {
                issueType = null;
            }
            if (schemeMap.put(issueType, value) == null) continue;
            this.delegator.removeValue(value);
        }
        ArrayList enties = Lists.newArrayList();
        for (Map.Entry<String, String> expectedEntry : state.getMappings().entrySet()) {
            String issueType = expectedEntry.getKey();
            String workflowName = expectedEntry.getValue();
            GenericValue currentGv = (GenericValue)schemeMap.remove(issueType);
            if (currentGv == null) {
                enties.add(this.createMapping(state.getId(), expectedEntry.getKey(), workflowName));
                continue;
            }
            String currentWorkflow = currentGv.getString("workflow");
            if (!currentWorkflow.equals(workflowName)) {
                currentGv.setString("workflow", workflowName);
                this.delegator.store(currentGv);
            }
            enties.add(currentGv);
        }
        for (GenericValue genericValue : schemeMap.values()) {
            this.delegator.removeValue(genericValue);
        }
        return this.createStateFrom(schemeGv, enties);
    }

    @Override
    public boolean delete(long id) {
        GenericValue schemeGv = this.delegator.findByPrimaryKey("DraftWorkflowScheme", Long.valueOf(id));
        if (schemeGv != null) {
            this.delegator.removeRelated("ChildDraftWorkflowSchemeEntity", schemeGv);
            this.delegator.removeValue(schemeGv);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteByParentId(long parentId) {
        GenericValue schemeGvFromParent = this.findSchemeGvFromParent(parentId);
        return schemeGvFromParent != null && this.delete(schemeGvFromParent.getLong("id"));
    }

    @Override
    public boolean hasDraftForParent(long parentId) {
        return this.findSchemeGvFromParent(parentId) != null;
    }

    @Override
    public DraftWorkflowSchemeStore.DraftWorkflowSchemeState getDraftForParent(long parentId) {
        return this.createStateFrom(this.findSchemeGvFromParent(parentId));
    }

    @Override
    public DraftWorkflowSchemeStore.DraftWorkflowSchemeState get(long id) {
        GenericValue schemeGv = this.getGenericValue(id);
        return this.createStateFrom(schemeGv);
    }

    private GenericValue getGenericValue(long id) {
        return this.delegator.findByPrimaryKey("DraftWorkflowScheme", Long.valueOf(id));
    }

    @Override
    public Iterable<DraftWorkflowSchemeStore.DraftWorkflowSchemeState> getAll() {
        List allGvs = this.delegator.findAll("DraftWorkflowScheme");
        ArrayList all = Lists.newArrayListWithExpectedSize((int)allGvs.size());
        for (GenericValue schemeGv : allGvs) {
            all.add(this.createStateFrom(schemeGv));
        }
        return all;
    }

    @Override
    public DraftWorkflowSchemeStore.DraftWorkflowSchemeState.Builder builder(long parentId) {
        return new DefaultWorkflowSchemeStateBuilder(parentId);
    }

    @Override
    public boolean renameWorkflow(String oldName, String newName) {
        return this.delegator.bulkUpdateByAnd("DraftWorkflowSchemeEntity", (Map)ImmutableMap.of((Object)"workflow", (Object)newName), (Map)ImmutableMap.of((Object)"workflow", (Object)oldName)) > 0;
    }

    @Override
    public long getParentId(long id) {
        GenericValue draftValue = this.getGenericValue(id);
        return draftValue.getLong("workflowSchemeId");
    }

    private static Timestamp currentDate() {
        return new Timestamp(System.currentTimeMillis());
    }

    private GenericValue createMapping(Long schemeId, String issueType, String workflow) {
        FieldMap entityMap = FieldMap.build((String)"scheme", (Object)schemeId);
        entityMap.add("issuetype", (Object)(issueType == null ? ALL_ISSUE_TYPES : issueType));
        entityMap.add("workflow", (Object)workflow);
        return this.delegator.createValue("DraftWorkflowSchemeEntity", (Map)entityMap);
    }

    private DraftWorkflowSchemeStore.DraftWorkflowSchemeState createStateFrom(GenericValue schemeGv) {
        if (schemeGv == null) {
            return null;
        }
        return this.createStateFrom(schemeGv, this.delegator.getRelated("ChildDraftWorkflowSchemeEntity", schemeGv));
    }

    private DraftWorkflowSchemeStore.DraftWorkflowSchemeState createStateFrom(GenericValue schemeGv, Iterable<GenericValue> entities) {
        Long parentId = schemeGv.getLong("workflowSchemeId");
        DefaultWorkflowSchemeStateBuilder builder = new DefaultWorkflowSchemeStateBuilder(parentId);
        builder.setId(schemeGv.getLong("id"));
        builder.setName(schemeGv.getString("name"));
        builder.setDescription(schemeGv.getString("description"));
        builder.setLastModifiedUser(schemeGv.getString("lastModifiedUser"));
        Timestamp timestamp = schemeGv.getTimestamp("lastModifiedDate");
        if (timestamp != null) {
            builder.setLastModifiedDate(new Date(timestamp.getTime()));
        } else {
            builder.setLastModifiedDate(new Date(0L));
        }
        for (GenericValue value : entities) {
            String issueType = value.getString("issuetype");
            String workflowName = value.getString("workflow");
            if (issueType == null) continue;
            if (ALL_ISSUE_TYPES.equals(issueType)) {
                builder.setDefaultWorkflow(workflowName);
                continue;
            }
            builder.setMapping(issueType, workflowName);
        }
        return builder.build();
    }

    private GenericValue findSchemeGvFromParent(long id) {
        List byAnd = this.delegator.findByAnd("DraftWorkflowScheme", (Map)ImmutableMap.of((Object)"workflowSchemeId", (Object)id));
        return EntityUtil.getOnly((List)byAnd);
    }

    private static class DraftWorkflowSchemeStateImpl
    implements DraftWorkflowSchemeStore.DraftWorkflowSchemeState {
        private final Long id;
        private final String name;
        private final String description;
        private final long parentSchemeId;
        private final Date lastModifiedDate;
        private final String lastModifiedUser;
        private final Map<String, String> issueTypeToWorkflow;

        private DraftWorkflowSchemeStateImpl(Long id, String name, String description, Long parentSchemeId, Map<String, String> issueTypeToWorkflow, Date lastModifiedDate, String lastModifiedUser) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.parentSchemeId = parentSchemeId;
            this.lastModifiedDate = lastModifiedDate;
            this.lastModifiedUser = lastModifiedUser;
            this.issueTypeToWorkflow = Collections.unmodifiableMap(Maps.newHashMap(issueTypeToWorkflow));
        }

        @Override
        public String getDefault() {
            return this.issueTypeToWorkflow.get(null);
        }

        @Override
        public long getParentSchemeId() {
            return this.parentSchemeId;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Long getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<String, String> getMappings() {
            return this.issueTypeToWorkflow;
        }

        @Override
        public String getDefaultWorkflow() {
            return this.issueTypeToWorkflow.get(null);
        }

        @Override
        public Date getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public String getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        @Override
        public DefaultWorkflowSchemeStateBuilder builder() {
            return new DefaultWorkflowSchemeStateBuilder(this);
        }
    }

    private static class DefaultWorkflowSchemeStateBuilder
    implements DraftWorkflowSchemeStore.DraftWorkflowSchemeState.Builder {
        private Long id;
        private String name;
        private String description;
        private final long parentId;
        private String lastModifiedUser;
        private Date lastModifiedDate;
        private Map<String, String> schemeMap;

        DefaultWorkflowSchemeStateBuilder(long parentId) {
            this.parentId = parentId;
            this.schemeMap = Maps.newHashMap();
        }

        DefaultWorkflowSchemeStateBuilder(DraftWorkflowSchemeStore.DraftWorkflowSchemeState state) {
            this.id = state.getId();
            this.name = state.getName();
            this.description = state.getDescription();
            this.parentId = state.getParentSchemeId();
            this.schemeMap = Maps.newHashMap(state.getMappings());
            this.lastModifiedDate = state.getLastModifiedDate();
            this.lastModifiedUser = state.getLastModifiedUser();
        }

        @Override
        public String getDefaultWorkflow() {
            return this.schemeMap.get(null);
        }

        private DefaultWorkflowSchemeStateBuilder setDefaultWorkflow(String defaultWorkflow) {
            this.schemeMap.put(null, defaultWorkflow);
            return this;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public DefaultWorkflowSchemeStateBuilder setDescription(String description) {
            this.description = StringUtils.stripToNull((String)description);
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DefaultWorkflowSchemeStateBuilder setName(String name) {
            name = StringUtils.stripToNull((String)name);
            Assertions.notNull((String)"name", (Object)name);
            if (name.length() > 255) {
                throw new IllegalArgumentException("name cannot be larger than 255 characters.");
            }
            this.name = name;
            return this;
        }

        @Override
        public Long getId() {
            return this.id;
        }

        @Override
        public String getDefault() {
            return this.schemeMap.get(null);
        }

        private Long setId(Long id) {
            this.id = id;
            return id;
        }

        @Override
        public long getParentSchemeId() {
            return this.parentId;
        }

        @Override
        public Map<String, String> getMappings() {
            return this.schemeMap;
        }

        private DefaultWorkflowSchemeStateBuilder setMapping(String type, String workflow) {
            this.schemeMap.put(type, workflow);
            return this;
        }

        @Override
        public DraftWorkflowSchemeStore.DraftWorkflowSchemeState.Builder setMappings(Map<String, String> mappings) {
            Assertions.notNull((String)"mappings", mappings);
            HashMap schemeMap = Maps.newHashMap();
            for (Map.Entry<String, String> entries : mappings.entrySet()) {
                String value;
                String key = entries.getKey();
                if (key != null) {
                    if (StringUtils.isBlank((String)key)) {
                        throw new IllegalArgumentException("issueTypeId cannot be blank.");
                    }
                    if (key.length() > 255) {
                        throw new IllegalArgumentException("issueTypeId '" + key + "' is too long.");
                    }
                }
                if (StringUtils.isBlank((String)(value = entries.getValue()))) {
                    throw new IllegalArgumentException(String.format("workflowName in mappings[%s] cannot be blank.", key));
                }
                if (value.length() > 255) {
                    throw new IllegalArgumentException(String.format("workflowName in mappings[%s] = %s too long.", key, value));
                }
                schemeMap.put(key, value);
            }
            this.schemeMap = schemeMap;
            return this;
        }

        @Override
        public String getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        @Override
        public DraftWorkflowSchemeStore.DraftWorkflowSchemeState.Builder setLastModifiedUser(String user) {
            this.lastModifiedUser = user;
            return this;
        }

        private DraftWorkflowSchemeStore.DraftWorkflowSchemeState.Builder setLastModifiedDate(Date date) {
            this.lastModifiedDate = date;
            return this;
        }

        @Override
        public Date getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public DraftWorkflowSchemeStore.DraftWorkflowSchemeState build() {
            return new DraftWorkflowSchemeStateImpl(this.id, this.name, this.description, this.parentId, this.schemeMap, this.lastModifiedDate, this.lastModifiedUser);
        }
    }

    private static class EntityTable {
        private static final String ENTITY = "DraftWorkflowSchemeEntity";

        private EntityTable() {
        }

        private static class Columns {
            private static final String WORKFLOW_SCHEME = "scheme";
            private static final String WORKFLOW_NAME = "workflow";
            private static final String ISSUE_TYPE = "issuetype";

            private Columns() {
            }
        }
    }

    private static class SchemeTable {
        private static final String ENTITY = "DraftWorkflowScheme";
        private static final String ENTITY_RELATIONSHIP = "ChildDraftWorkflowSchemeEntity";

        private SchemeTable() {
        }

        private static class Columns {
            private static final String ID = "id";
            private static final String NAME = "name";
            private static final String DESCRIPTION = "description";
            private static final String PARENT = "workflowSchemeId";
            private static final String UPDATED_DATE = "lastModifiedDate";
            private static final String UPDATED_USER = "lastModifiedUser";

            private Columns() {
            }
        }
    }
}

