/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.AssignableWorkflowSchemeBuilder;
import com.atlassian.jira.workflow.WorkflowScheme;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;

class DefaultWorkflowScheme
implements AssignableWorkflowScheme {
    private static final Map<String, String> WORKFLOW_MAP = Collections.singletonMap(null, "jira");
    private final JiraAuthenticationContext ctx;

    DefaultWorkflowScheme(JiraAuthenticationContext ctx) {
        this.ctx = ctx;
    }

    public Long getId() {
        return null;
    }

    @Nonnull
    public String getName() {
        return this.ctx.getI18nHelper().getText("admin.schemes.workflows.default");
    }

    public String getDescription() {
        return this.ctx.getI18nHelper().getText("admin.schemes.workflows.default.desc");
    }

    public boolean isDraft() {
        return false;
    }

    public boolean isDefault() {
        return true;
    }

    @Nonnull
    public String getActualWorkflow(String issueTypeId) {
        return "jira";
    }

    @Nonnull
    public String getActualDefaultWorkflow() {
        return "jira";
    }

    @Nonnull
    public Map<String, String> getMappings() {
        return WORKFLOW_MAP;
    }

    public String getConfiguredDefaultWorkflow() {
        return "jira";
    }

    public String getConfiguredWorkflow(String issueTypeId) {
        return null;
    }

    @Nonnull
    public AssignableWorkflowScheme.Builder builder() {
        return new AssignableWorkflowSchemeBuilder((WorkflowScheme)this);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 0;
    }
}

