/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.log4j.Logger;

@Immutable
public class ExternalLinkUtilImpl
implements ExternalLinkUtil {
    protected final Logger log = Logger.getLogger(ExternalLinkUtil.class);
    private static final String PROPERTIES_FILE_LOCATION = "external-links.properties";
    private static final ExternalLinkUtil instance = new ExternalLinkUtilImpl();
    private Properties props;

    public ExternalLinkUtilImpl() {
        this.init(PROPERTIES_FILE_LOCATION);
    }

    @Override
    public String getPropertiesFilename() {
        return PROPERTIES_FILE_LOCATION;
    }

    public ExternalLinkUtilImpl(String propFileLocation) {
        this.init(propFileLocation);
    }

    public static ExternalLinkUtil getInstance() {
        return instance;
    }

    @Override
    public String getProperty(String key) {
        if (this.props.containsKey(key)) {
            return (String)this.props.get(key);
        }
        return key;
    }

    @Override
    public String getProperty(String key, String value1) {
        return this.getProperty(key, EasyList.build((Object)value1));
    }

    @Override
    public String getProperty(String key, String value1, String value2) {
        return this.getProperty(key, EasyList.build((Object)value1, (Object)value2));
    }

    @Override
    public String getProperty(String key, String value1, String value2, String value3) {
        return this.getProperty(key, EasyList.build((Object)value1, (Object)value2, (Object)value3));
    }

    @Override
    public String getProperty(String key, String value1, String value2, String value3, String value4) {
        return this.getProperty(key, EasyList.build((Object)value1, (Object)value2, (Object)value3, (Object)value4));
    }

    @Override
    public String getProperty(String string, Object parameters) {
        Object[] params = parameters instanceof List ? ((List)parameters).toArray() : (parameters instanceof Object[] ? (Object[])parameters : new Object[]{parameters});
        String message = this.getProperty(string);
        MessageFormat mf = new MessageFormat(message);
        return mf.format(params);
    }

    private void init(String propFileLocation) {
        this.props = new Properties();
        try {
            this.props.load(ClassLoaderUtils.getResourceAsStream((String)propFileLocation, ExternalLinkUtilImpl.class));
        }
        catch (IOException e) {
            this.log.warn((Object)("Unable to load the " + propFileLocation + " file"));
        }
    }
}

