/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.ImageScaler;
import com.atlassian.jira.avatar.TemporaryAvatar;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.web.servlet.ViewProjectAvatarServlet;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewTemporaryAvatarServlet
extends ViewProjectAvatarServlet {
    private static final int BUFFER_SIZE = 8192;
    private static final String PARAM_SIZE = "size";
    private static final String PARAM_CROPPED = "cropped";

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TemporaryAvatar temporaryAvatar = (TemporaryAvatar)request.getSession().getAttribute("tempAvatarFile");
        if (temporaryAvatar == null || !temporaryAvatar.getFile().exists()) {
            response.sendError(404);
            return;
        }
        response.setHeader("Expires", "Fri, 01 Jan 1990 00:00:00 GMT");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-control", "no-cache, must-revalidate");
        response.setContentType(temporaryAvatar.getTemporaryContentType());
        ServletOutputStream out = response.getOutputStream();
        boolean bytesWritten = false;
        try {
            if ("true".equalsIgnoreCase(request.getParameter(PARAM_CROPPED)) && temporaryAvatar.getSelection() != null) {
                ImageScaler scaler = new ImageScaler();
                AvatarManager.ImageSize size = AvatarManager.ImageSize.fromString((String)request.getParameter(PARAM_SIZE));
                RenderedImage image = scaler.getSelectedImageData(ImageIO.read(new FileInputStream(temporaryAvatar.getFile())), temporaryAvatar.getSelection(), size.getPixels());
                ImageIO.write(image, AvatarManager.AVATAR_IMAGE_FORMAT_FULL.getName(), (OutputStream)out);
            } else {
                IOUtil.copy((InputStream)new FileInputStream(temporaryAvatar.getFile()), (OutputStream)out, 8192);
            }
            bytesWritten = true;
        }
        catch (IOException e) {
            ViewTemporaryAvatarServlet.handleOutputStreamingException(response, bytesWritten, e);
        }
    }
}

