/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.less.inlineimage;

import com.atlassian.jira.issue.attachment.MimetypesFileTypeMap;
import com.atlassian.jira.web.less.LessTransformer;
import com.atlassian.jira.web.less.inlineimage.InlineImage;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class InlineImageEncoder {
    public static ThreadLocal<LessTransformer.LessResource.BaseLoader> resourceLoader = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InlineImage encode(String imagePath) {
        String data;
        block6: {
            try {
                InputStream imageInputStream = InlineImageEncoder.getLoader().getResourceInputStream(imagePath);
                if (imageInputStream != null) {
                    try {
                        data = InlineImageEncoder.encode(imageInputStream);
                        break block6;
                    }
                    finally {
                        imageInputStream.close();
                    }
                }
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new InlineImage(data, MimetypesFileTypeMap.getContentType(imagePath));
    }

    @VisibleForTesting
    static String encode(InputStream inputStream) throws IOException {
        return new String(Base64.encodeBase64((byte[])IOUtils.toByteArray((InputStream)inputStream)));
    }

    public static LessTransformer.LessResource.BaseLoader getLoader() {
        return resourceLoader.get();
    }

    public static void setLoader(LessTransformer.LessResource.BaseLoader loader) {
        resourceLoader.set(loader);
    }
}

