/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.renderer.ProjectDescriptionRenderer;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.project.ViewProject;
import webwork.action.ActionContext;

public class EditProject
extends ViewProject {
    private final ProjectService projectService;
    private AvatarManager avatarManager;
    private final UserManager userManager;
    private final ProjectDescriptionRenderer projectDescriptionRenderer;

    public EditProject(ProjectService projectService, AvatarManager avatarManager, UserManager userManager) {
        this.projectService = projectService;
        this.avatarManager = avatarManager;
        this.userManager = userManager;
        this.projectDescriptionRenderer = (ProjectDescriptionRenderer)ComponentAccessor.getComponentOfType(ProjectDescriptionRenderer.class);
    }

    @Override
    public String doDefault() throws Exception {
        if (this.getProject() == null) {
            return this.handleProjectDoesNotExist();
        }
        if (!this.hasProjectAdminPermission() && !this.hasAdminPermission()) {
            return "securitybreach";
        }
        this.setName(this.getProject().getString("name"));
        this.setLead(this.getProject().getString("lead"));
        this.setKey(this.getProject().getString("key"));
        this.setUrl(this.getProject().getString("url"));
        this.setDescription(this.getProject().getString("description"));
        this.setAssigneeType(this.getProject().getLong("assigneetype"));
        return "input";
    }

    private String handleProjectDoesNotExist() throws Exception {
        if (this.hasAdminPermission()) {
            this.setName("???");
            this.addErrorMessage(this.getText("admin.errors.project.no.project.with.id"));
            return super.doDefault();
        }
        return "securitybreach";
    }

    @Override
    protected void doValidation() {
        if (this.getProject() == null) {
            this.addErrorMessage(this.getText("admin.errors.project.no.project.with.id"));
            return;
        }
        Project projectObject = this.getProjectObject();
        ProjectService.UpdateProjectValidationResult result = this.projectService.validateUpdateProject(this.getLoggedInUser(), this.getName(), projectObject.getKey(), this.getDescription(), projectObject.getLeadUserName(), this.getUrl(), projectObject.getAssigneeType());
        if (!result.isValid()) {
            this.mapErrorCollection(result.getErrorCollection());
        }
        super.doValidation();
    }

    public String getAvatarUrl() {
        return ActionContext.getRequest().getContextPath() + "/secure/projectavatar?pid=" + this.getPid() + "&size=large&avatarId=" + this.getProjectObject().getAvatar().getId();
    }

    public ProjectDescriptionRenderer getProjectDescriptionRenderer() {
        return this.projectDescriptionRenderer;
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (!this.hasProjectAdminPermission() && !this.hasAdminPermission()) {
            return "securitybreach";
        }
        Project projectObject = this.getProjectObject();
        ProjectService.UpdateProjectValidationResult result = this.projectService.validateUpdateProject(this.getLoggedInUser(), this.getName(), projectObject.getKey(), this.getDescription(), projectObject.getLeadUserName(), this.getUrl(), projectObject.getAssigneeType());
        this.projectService.updateProject(result);
        if (this.isInlineDialogMode()) {
            return this.returnComplete();
        }
        return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getString("key") + "/summary");
    }

    public boolean hasInvalidLead() {
        Project projectObject = this.getProjectObject();
        if (projectObject == null) {
            return false;
        }
        String leadUserName = projectObject.getLeadUserName();
        return this.userManager.getUserObject(leadUserName) == null;
    }

    public Long getDefaultAvatar() {
        return this.avatarManager.getDefaultAvatarId(Avatar.Type.PROJECT);
    }
}

