/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import webwork.action.ActionContext;

@WebSudoRequired
public class ViewLicense
extends JiraWebActionSupport {
    private final UserUtil userUtil;
    private final LicenseJohnsonEventRaiser licenseJohnsonEventRaiser;
    private final JiraLicenseUpdaterService jiraLicenseService;
    private String licenseString = "";
    private LicenseDetails licenseDetails;
    private JiraLicenseService.ValidationResult validationResult;

    public ViewLicense(UserUtil userUtil, JiraLicenseUpdaterService jiraLicenseService, LicenseJohnsonEventRaiser licenseJohnsonEventRaiser) {
        this.licenseJohnsonEventRaiser = (LicenseJohnsonEventRaiser)Assertions.notNull((String)"licenseJohnsonEventRaiser", (Object)licenseJohnsonEventRaiser);
        this.jiraLicenseService = (JiraLicenseUpdaterService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.userUtil = (UserUtil)Assertions.notNull((String)"userUtil", (Object)userUtil);
    }

    public LicenseDetails getLicenseDetails() {
        if (this.licenseDetails == null) {
            this.licenseDetails = this.jiraLicenseService.getLicense();
        }
        return this.licenseDetails;
    }

    public String doRefreshActiveUserCount() {
        this.userUtil.clearActiveUserCount();
        this.userUtil.getActiveUserCount();
        return "success";
    }

    protected void doValidation() {
        this.validationResult = this.jiraLicenseService.validate((I18nHelper)this, this.licenseString);
        if (this.validationResult.getErrorCollection().hasAnyErrors()) {
            this.addErrorCollection(this.validationResult.getErrorCollection());
        }
    }

    public String doDefault() {
        return "input";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.licenseDetails = this.jiraLicenseService.setLicense(this.validationResult);
        this.licenseString = "";
        if (this.licenseJohnsonEventRaiser.checkLicenseIsTooOldForBuild(ActionContext.getServletContext(), this.licenseDetails)) {
            return this.getRedirect("/secure/errors.jsp");
        }
        return "success";
    }

    public void setLicense(String license) {
        this.licenseString = license;
    }

    public String getLicense() {
        return this.licenseString;
    }

    public boolean isPersonalLicense() {
        return this.getLicenseDetails().isPersonalLicense();
    }

    public boolean isLicenseRequiresUserLimit() {
        return !this.getLicenseDetails().isUnlimitedNumberOfUsers();
    }

    public int getActiveUserCount() {
        return this.userUtil.getActiveUserCount();
    }

    public boolean hasExceededUserLimit() {
        return this.userUtil.hasExceededUserLimit();
    }

    public String getLicenseStatusMessage() {
        return this.getLicenseDetails().getLicenseStatusMessage(this.getLoggedInUser(), "<br/><br/>");
    }

    public String getLicenseExpiryStatusMessage() {
        return this.getLicenseDetails().getLicenseExpiryStatusMessage(this.getLoggedInUser());
    }

    public String getPurchaseDate() {
        return this.licenseDetails.getPurchaseDate(this.getOutlookDate());
    }
}

