/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.http.response;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CapturingResponseWrapper
extends HttpServletResponseWrapper {
    private final long maxCaptureLen;
    private final List cookieList;
    private final List headerList;
    private final ByteArrayOutputStream byteArrayOutputStream;
    private final Writer byteArrayWriter;
    private CapturingPrintWriter writer;
    private CapturingServletOutputStream outputStream;

    public CapturingResponseWrapper(HttpServletResponse httpServletResponse, int maxCaptureLen) {
        super(httpServletResponse);
        this.maxCaptureLen = maxCaptureLen;
        this.headerList = new ArrayList();
        this.cookieList = new ArrayList();
        this.byteArrayOutputStream = new ByteArrayOutputStream(maxCaptureLen);
        this.byteArrayWriter = new OutputStreamWriter(this.byteArrayOutputStream);
    }

    public byte[] getBytes() {
        try {
            this.byteArrayWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.byteArrayOutputStream.toByteArray();
    }

    public int size() {
        try {
            this.byteArrayWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.byteArrayOutputStream.size();
    }

    public List getCookieList() {
        return Collections.unmodifiableList(this.cookieList);
    }

    public List getHeaderList() {
        return Collections.unmodifiableList(this.headerList);
    }

    public void addCookie(Cookie cookie) {
        super.addCookie(cookie);
        this.cookieList.add(cookie);
    }

    private void setHeader(HttpHeader header) {
        int index = this.findNamedHeader(header.getName());
        if (index == -1) {
            this.headerList.add(header);
        } else {
            this.headerList.set(index, header);
        }
    }

    private int findNamedHeader(String name) {
        for (int i = 0; i < this.headerList.size(); ++i) {
            HttpHeader httpHeader = (HttpHeader)this.headerList.get(i);
            if (!httpHeader.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private void addHeader(HttpHeader header) {
        this.headerList.add(header);
    }

    public void setDateHeader(String s, long l) {
        super.setDateHeader(s, l);
        this.setHeader(new HttpHeader(s, new Date(l)));
    }

    public void addDateHeader(String s, long l) {
        super.addDateHeader(s, l);
        this.addHeader(new HttpHeader(s, new Date(l)));
    }

    public void setHeader(String s, String s1) {
        super.setHeader(s, s1);
        this.setHeader(new HttpHeader(s, s1));
    }

    public void addHeader(String s, String s1) {
        super.addHeader(s, s1);
        this.addHeader(new HttpHeader(s, s1));
    }

    public void setIntHeader(String s, int i) {
        super.setIntHeader(s, i);
        this.setHeader(new HttpHeader(s, new Integer(i)));
    }

    public void addIntHeader(String s, int i) {
        super.addIntHeader(s, i);
        this.addHeader(new HttpHeader(s, new Integer(i)));
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new CapturingPrintWriter(super.getWriter());
        }
        return this.writer;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new CapturingServletOutputStream(super.getOutputStream());
        }
        return this.outputStream;
    }

    private class CapturingServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream delegateStream;

        private CapturingServletOutputStream(ServletOutputStream delegateStream) {
            this.delegateStream = delegateStream;
        }

        private void capture(byte[] bytes, int offset, int len) {
            long roomLeft = CapturingResponseWrapper.this.maxCaptureLen - (long)CapturingResponseWrapper.this.size();
            if (roomLeft > 0L) {
                CapturingResponseWrapper.this.byteArrayOutputStream.write(bytes, offset, len);
            }
        }

        private void capture(byte b) {
            long roomLeft = CapturingResponseWrapper.this.maxCaptureLen - (long)CapturingResponseWrapper.this.size();
            if (roomLeft > 0L) {
                CapturingResponseWrapper.this.byteArrayOutputStream.write(b);
            }
        }

        public void write(int b) throws IOException {
            this.delegateStream.write(b);
            this.capture((byte)b);
        }

        public void write(byte[] b) throws IOException {
            this.delegateStream.write(b);
            this.capture(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegateStream.write(b, off, len);
            this.capture(b, off, len);
        }

        public void close() throws IOException {
            this.delegateStream.close();
        }

        public void flush() throws IOException {
            this.delegateStream.flush();
        }
    }

    private class CapturingPrintWriter
    extends PrintWriter {
        private CapturingPrintWriter(PrintWriter delegate) {
            super(delegate);
        }

        private void capture(char[] buf, int off, int len) {
            long roomLeft = CapturingResponseWrapper.this.maxCaptureLen - (long)CapturingResponseWrapper.this.size();
            if (roomLeft > 0L) {
                len = (int)Math.min(roomLeft, (long)len);
                try {
                    CapturingResponseWrapper.this.byteArrayWriter.write(buf, off, len);
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }

        @Override
        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            if ((long)CapturingResponseWrapper.this.size() < CapturingResponseWrapper.this.maxCaptureLen) {
                this.capture(buf, off, len);
            }
        }

        @Override
        public void write(String s, int off, int len) {
            super.write(s, off, len);
            if ((long)CapturingResponseWrapper.this.size() < CapturingResponseWrapper.this.maxCaptureLen) {
                this.capture(s.toCharArray(), off, len);
            }
        }

        @Override
        public void println() {
            super.println();
            if ((long)CapturingResponseWrapper.this.size() < CapturingResponseWrapper.this.maxCaptureLen) {
                this.capture(new char[]{'\n'}, 0, 1);
            }
        }
    }

    public static class HttpHeader {
        private String headerName;
        private Object headerValue;
        private static final String HTTP_HEADER_DF = "dd/MMM/yyyy:HH:mm:ss Z";

        private HttpHeader(String headerName, Object headerValue) {
            this.headerName = headerName;
            this.headerValue = headerValue;
        }

        public String getName() {
            return this.headerName;
        }

        public String getValue() {
            if (this.headerValue instanceof Date) {
                return this.formatDate((Date)this.headerValue);
            }
            return String.valueOf(this.headerValue);
        }

        private String formatDate(Date date) {
            return new SimpleDateFormat(HTTP_HEADER_DF).format(date);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HttpHeader header = (HttpHeader)o;
            if (this.headerName != null ? !this.headerName.equals(header.headerName) : header.headerName != null) {
                return false;
            }
            return !(this.headerValue == null ? header.headerValue != null : !this.headerValue.equals(header.headerValue));
        }

        public int hashCode() {
            int result = this.headerName != null ? this.headerName.hashCode() : 0;
            result = 31 * result + (this.headerValue != null ? this.headerValue.hashCode() : 0);
            return result;
        }

        public String toString() {
            return new StringBuffer(this.headerName).append("=").append(this.headerValue).toString();
        }
    }
}

