/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.user.ExternalEntityStore;
import java.util.concurrent.ConcurrentHashMap;

@EventComponent
public class CachingExternalEntityStore
implements ExternalEntityStore {
    protected final ConcurrentHashMap<String, Long> nameIdMap = new ConcurrentHashMap();
    private final ExternalEntityStore delegateEntityStore;

    public CachingExternalEntityStore(ExternalEntityStore delegateEntityStore) {
        this.delegateEntityStore = delegateEntityStore;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.nameIdMap.clear();
    }

    @Override
    public Long createIfDoesNotExist(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("ExternalEntity user name must not be null.");
        }
        String lowercaseName = IdentifierUtils.toLowerCase((String)name);
        Long idForName = this.nameIdMap.get(lowercaseName);
        if (idForName == null) {
            idForName = this.delegateEntityStore.createIfDoesNotExist(name);
            this.nameIdMap.putIfAbsent(lowercaseName, idForName);
        }
        return idForName;
    }
}

