/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.util.ObjectUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.permission.Permission;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build47
extends AbstractUpgradeTask {
    private final PermissionSchemeManager psm;
    private final SchemePermissions schemePermissions;

    public UpgradeTask_Build47(PermissionSchemeManager psm, SchemePermissions schemePermissions) {
        super(false);
        this.psm = psm;
        this.schemePermissions = schemePermissions;
    }

    @Override
    public String getBuildNumber() {
        return "47";
    }

    @Override
    public String getShortDescription() {
        return "Create permission schemes and migrate data";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Set<Map.Entry<Integer, Permission>> permSet = this.schemePermissions.getSchemePermissions().entrySet();
        GenericValue defaultScheme = this.psm.createDefaultScheme();
        for (Map.Entry<Integer, Permission> mapEntry : permSet) {
            Integer type = mapEntry.getKey();
            this.addOldGlobalPermissionsToScheme((SchemeManager)this.psm, type, defaultScheme);
        }
        this.addOldGlobalPermissionsToScheme((SchemeManager)this.psm, 0, null);
        this.addOldGlobalPermissionsToScheme((SchemeManager)this.psm, 1, null);
        this.addOldGlobalPermissionsToScheme((SchemeManager)this.psm, 24, null);
        this.createProjectSchemes((SchemeManager)this.psm, defaultScheme);
        this.mergeDuplicateSchemes((SchemeManager)this.psm);
        ManagerFactory.getPermissionSchemeManager().flushSchemeEntities();
    }

    public void addOldGlobalPermissionsToScheme(SchemeManager psm, int permType, GenericValue scheme) throws GenericEntityException, CreateException {
        List globalPermissions = ComponentAccessor.getOfBizDelegator().findByAnd("Permission", EasyMap.build((Object)"type", (Object)new Long(permType), (Object)"project", null));
        for (GenericValue perm : globalPermissions) {
            if (scheme == null) {
                ManagerFactory.getGlobalPermissionManager().addPermission(permType, perm.getString("group"));
                continue;
            }
            psm.createSchemeEntity(scheme, new SchemeEntity("group", perm.getString("group"), (Object)new Long(permType)));
        }
    }

    public void addOldProjectPermissionsToScheme(SchemeManager psm, int permType, GenericValue scheme, Long project) throws GenericEntityException {
        List globalPermissions = ComponentAccessor.getOfBizDelegator().findByAnd("Permission", EasyMap.build((Object)"type", (Object)new Long(permType), (Object)"project", (Object)project));
        for (GenericValue perm : globalPermissions) {
            List perms = psm.getEntities(scheme, new Long(permType), perm.getString("group"));
            if (perms != null && perms.size() != 0) continue;
            psm.createSchemeEntity(scheme, new SchemeEntity("group", perm.getString("group"), (Object)new Long(permType)));
        }
    }

    public void createProjectSchemes(SchemeManager psm, GenericValue defaultScheme) throws GenericEntityException, CreateException {
        List projects = UpgradeTask_Build47.getOfBizDelegator().findAll("Project");
        for (GenericValue project : projects) {
            List permissions = ComponentAccessor.getOfBizDelegator().findByAnd("Permission", EasyMap.build((Object)"project", (Object)project.getLong("id")));
            if (permissions != null && permissions.size() > 0) {
                GenericValue projectScheme = psm.createScheme(project.getString("name"), "This permission scheme has been set up for Project " + project.getString("name"));
                psm.addSchemeToProject(project, projectScheme);
                Set<Map.Entry<Integer, Permission>> permSet = this.schemePermissions.getSchemePermissions().entrySet();
                for (Map.Entry<Integer, Permission> mapEntry : permSet) {
                    Integer type = mapEntry.getKey();
                    this.addOldGlobalPermissionsToScheme(psm, type, projectScheme);
                    this.addOldProjectPermissionsToScheme(psm, type, projectScheme, project.getLong("id"));
                }
                continue;
            }
            psm.addSchemeToProject(project, defaultScheme);
        }
    }

    public void mergeDuplicateSchemes(SchemeManager psm) throws Exception {
        Iterator schemes = psm.getSchemes().iterator();
        while (schemes.hasNext()) {
            GenericValue scheme = (GenericValue)schemes.next();
            if (!this.mergeSchemeIter(psm, scheme)) continue;
            schemes = psm.getSchemes().iterator();
        }
    }

    public boolean mergeSchemeIter(SchemeManager psm, GenericValue scheme) throws Exception {
        boolean modified = false;
        Iterator schemes = psm.getSchemes().iterator();
        while (schemes.hasNext()) {
            GenericValue schemeB = (GenericValue)schemes.next();
            if (scheme.equals((Object)schemeB) || scheme.equals((Object)psm.getDefaultScheme()) || schemeB.equals((Object)psm.getDefaultScheme()) || !this.isDuplicate(psm, scheme, schemeB)) continue;
            this.deleteSchemeAndMoveProjects(psm, scheme, schemeB);
            schemes.remove();
            modified = true;
        }
        return modified;
    }

    public void deleteSchemeAndMoveProjects(SchemeManager psm, GenericValue schemeA, GenericValue schemeB) throws Exception {
        List projects = psm.getProjects(schemeB);
        psm.deleteScheme(schemeB.getLong("id"));
        for (GenericValue project : projects) {
            psm.addSchemeToProject(project, schemeA);
            schemeA.set("name", (Object)(schemeA.getString("name") + ", " + project.getString("name")));
            schemeA.set("description", (Object)(schemeA.getString("description") + ", " + project.getString("name")));
        }
        String schemeName = schemeA.getString("name");
        if (schemeName != null && schemeName.length() > 250) {
            schemeA.set("name", (Object)(schemeName.substring(0, 245) + "..."));
        }
        schemeA.store();
    }

    public boolean isDuplicate(SchemeManager psm, GenericValue schemeA, GenericValue schemeB) throws GenericEntityException {
        List permissionsA = psm.getEntities(schemeA);
        List permissionsB = psm.getEntities(schemeB);
        if (permissionsA.size() == permissionsB.size()) {
            Collections.sort(new ArrayList(permissionsA));
            Collections.sort(new ArrayList(permissionsB));
            for (int i = 0; i < permissionsA.size(); ++i) {
                GenericValue permA = (GenericValue)permissionsA.get(i);
                GenericValue permB = (GenericValue)permissionsB.get(i);
                if (!permA.getLong("permission").equals(permB.getLong("permission"))) {
                    return false;
                }
                if (ObjectUtils.isDifferent((Object)permA.getString("type"), (Object)permB.getString("type"))) {
                    return false;
                }
                if (!ObjectUtils.isDifferent((Object)permA.getString("parameter"), (Object)permB.getString("parameter"))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

