/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpgradeTask_Build151
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build151.class);
    private WorkflowManager workflowManager;

    public UpgradeTask_Build151(WorkflowManager workflowManager) {
        super(false);
        this.workflowManager = workflowManager;
    }

    @Override
    public String getBuildNumber() {
        return "151";
    }

    @Override
    public String getShortDescription() {
        return "Make minor workflow format changes to saved workflows";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Collection workflows = null;
        try {
            workflows = this.workflowManager.getWorkflows();
        }
        catch (Throwable t) {
            log.error((Object)"Error loading workflows. Upgrade task 151 not running. This is not critical, but you may wish to manually add 'jira.i18n.title' attributes to your workflows.", t);
            return;
        }
        for (JiraWorkflow jiraWorkflow : workflows) {
            if (jiraWorkflow.isSystemWorkflow()) continue;
            List initActions = jiraWorkflow.getDescriptor().getInitialActions();
            for (ActionDescriptor actionDescriptor : initActions) {
                Map metaAttributes = actionDescriptor.getMetaAttributes();
                if (metaAttributes.containsKey("jira.i18n.title")) continue;
                log.info((Object)("Adding jira.i18n.title attribute to initial action of workflow '" + jiraWorkflow.getName() + "'"));
                metaAttributes.put("jira.i18n.title", "common.forms.create");
                this.workflowManager.saveWorkflowWithoutAudit(jiraWorkflow);
            }
        }
    }
}

