/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.startup.JiraHomePathLocator;
import com.atlassian.util.concurrent.LazyReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ApplicationPropertiesJiraHomePathLocator
implements JiraHomePathLocator {
    private static final String APP_PROPERTIES_DEFAULTS = "jira-application.properties";
    private static final Logger log = Logger.getLogger(ApplicationPropertiesJiraHomePathLocator.class);
    LazyReference<Properties> applicationProperties = new LazyReference<Properties>(){

        protected Properties create() throws Exception {
            Properties defaultProperties = new Properties();
            InputStream in = ClassLoaderUtils.getResourceAsStream((String)ApplicationPropertiesJiraHomePathLocator.APP_PROPERTIES_DEFAULTS, ((Object)((Object)this)).getClass());
            try {
                defaultProperties.load(in);
                in.close();
            }
            catch (IOException e) {
                log.error((Object)"Could not load default properties from 'jira-application.properties'.  Not using default properties");
            }
            return defaultProperties;
        }
    };

    @Override
    public String getJiraHome() {
        return ((Properties)this.applicationProperties.get()).getProperty("jira.home");
    }

    @Override
    public String getDisplayName() {
        return "Application Properties";
    }
}

