/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.search.ProjectShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.ProjectSharePermission;
import com.atlassian.jira.sharing.type.ShareQueryFactory;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ProjectShareQueryFactory
implements ShareQueryFactory<ProjectShareTypeSearchParameter> {
    private final Visibility visibility;

    public ProjectShareQueryFactory(ProjectManager projectManager, ProjectRoleManager projectRoleManager, PermissionManager permissionManager, ProjectFactory projectFactory) {
        this(new VisibilityImpl(projectManager, projectRoleManager, permissionManager, projectFactory));
    }

    public ProjectShareQueryFactory(Visibility visibility) {
        this.visibility = visibility;
    }

    public Query getQuery(ShareTypeSearchParameter searchParameter, User user) {
        ProjectShareTypeSearchParameter projectParameter = (ProjectShareTypeSearchParameter)searchParameter;
        this.visibility.check(user, projectParameter);
        TermQuery projectQuery = new TermQuery(new Term("shareTypeProject", ProjectSharePermission.indexValue((Long)projectParameter.getProjectId(), (Long)projectParameter.getRoleId())));
        if (projectParameter.hasRole()) {
            return projectQuery;
        }
        BooleanQuery result = new BooleanQuery();
        result.add((Query)projectQuery, BooleanClause.Occur.SHOULD);
        for (ProjectRole role : this.visibility.getRoles(user, projectParameter.getProjectId())) {
            result.add((Query)new TermQuery(new Term("shareTypeProject", ProjectSharePermission.indexValue((Long)projectParameter.getProjectId(), (Long)role.getId()))), BooleanClause.Occur.SHOULD);
        }
        return result;
    }

    public Query getQuery(ShareTypeSearchParameter searchParameter) {
        ProjectShareTypeSearchParameter projectParameter = (ProjectShareTypeSearchParameter)searchParameter;
        TermQuery projectQuery = new TermQuery(new Term("shareTypeProject", ProjectSharePermission.indexValue((Long)projectParameter.getProjectId(), (Long)projectParameter.getRoleId())));
        if (projectParameter.hasRole()) {
            return projectQuery;
        }
        BooleanQuery result = new BooleanQuery();
        result.add((Query)projectQuery, BooleanClause.Occur.SHOULD);
        result.add((Query)new PrefixQuery(new Term("shareTypeProject", ProjectSharePermission.searchAllRolesValue((Long)projectParameter.getProjectId()))), BooleanClause.Occur.SHOULD);
        return result;
    }

    public Term[] getTerms(User user) {
        List<ProjectAndRole> projectsAndRoles = this.visibility.getProjects(user);
        ArrayList<Term> result = new ArrayList<Term>(projectsAndRoles.size());
        for (ProjectAndRole projectAndRole : projectsAndRoles) {
            result.add(new Term("shareTypeProject", ProjectSharePermission.indexValue((Long)projectAndRole.getProjectId(), (Long)projectAndRole.getRoleId())));
        }
        return result.toArray(new Term[result.size()]);
    }

    public Field getField(SharedEntity entity, SharePermission permission) {
        return new Field("shareTypeProject", new ProjectSharePermission(permission).getIndexValue(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    static class ProjectAndRole {
        private final Long projectId;
        private final Long projectRoleId;

        public ProjectAndRole(Long projectId) {
            this(projectId, null);
        }

        public ProjectAndRole(Long projectId, Long projectRoleId) {
            Assertions.notNull((String)"projectId", (Object)projectId);
            this.projectId = projectId;
            this.projectRoleId = projectRoleId;
        }

        Long getProjectId() {
            return this.projectId;
        }

        Long getRoleId() {
            return this.projectRoleId;
        }
    }

    static class VisibilityImpl
    implements Visibility {
        private final ProjectManager projectManager;
        private final ProjectRoleManager projectRoleManager;
        private final PermissionManager permissionManager;
        private final ProjectFactory projectFactory;

        VisibilityImpl(ProjectManager projectManager, ProjectRoleManager projectRoleManager, PermissionManager permissionManager, ProjectFactory projectFactory) {
            Assertions.notNull((String)"projectManager", (Object)projectManager);
            Assertions.notNull((String)"projectRoleManager", (Object)projectRoleManager);
            Assertions.notNull((String)"permissionManager", (Object)permissionManager);
            Assertions.notNull((String)"projectFactory", (Object)projectFactory);
            this.projectManager = projectManager;
            this.projectRoleManager = projectRoleManager;
            this.permissionManager = permissionManager;
            this.projectFactory = projectFactory;
        }

        @Override
        public void check(User user, ProjectShareTypeSearchParameter projectParameter) {
            ProjectRole role;
            Project project = this.projectManager.getProjectObj(projectParameter.getProjectId());
            if (!this.permissionManager.hasPermission(10, project, user)) {
                throw new IllegalStateException("Cannot search for a Project you cannot see: " + project);
            }
            Long roleId = projectParameter.getRoleId();
            if (roleId != null && !this.projectRoleManager.isUserInProjectRole(user, role = this.projectRoleManager.getProjectRole(roleId), project)) {
                throw new IllegalStateException("Cannot search for a ProjectRole you not a member of: " + role + " project:" + project);
            }
        }

        @Override
        public List<ProjectAndRole> getProjects(final User user) {
            Collection projectGvs = this.projectManager.getProjects();
            List projects = projectGvs == null ? Collections.emptyList() : this.projectFactory.getProjects(projectGvs);
            ArrayList<ProjectAndRole> result = new ArrayList<ProjectAndRole>();
            for (Project project : projects) {
                Collection roles = this.projectRoleManager.getProjectRoles(user, project);
                for (ProjectRole role : roles) {
                    result.add(new ProjectAndRole(project.getId(), role.getId()));
                }
            }
            for (Project project : CollectionUtil.filter((Collection)projects, (Predicate)new Predicate<Project>(){

                public boolean evaluate(Project o) {
                    return VisibilityImpl.this.permissionManager.hasPermission(10, o, user);
                }
            })) {
                result.add(new ProjectAndRole(project.getId()));
            }
            return Collections.unmodifiableList(result);
        }

        @Override
        public List<ProjectRole> getRoles(User user, Long projectId) {
            Project project = this.projectManager.getProjectObj(projectId);
            return Collections.unmodifiableList(new ArrayList(this.projectRoleManager.getProjectRoles(user, project)));
        }
    }

    static interface Visibility {
        public void check(User var1, ProjectShareTypeSearchParameter var2) throws IllegalStateException;

        public List<ProjectAndRole> getProjects(User var1);

        public List<ProjectRole> getRoles(User var1, Long var2);
    }

    private static final class Name {
        static final String FIELD = "shareTypeProject";

        private Name() {
        }
    }
}

