/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.DefaultPermissionSchemeManager;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.WorkflowPermission;
import com.atlassian.jira.permission.WorkflowPermissionFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.groups.GroupManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class WorkflowBasedPermissionSchemeManager
extends DefaultPermissionSchemeManager
implements Startable {
    private static final Logger log = Logger.getLogger(WorkflowBasedPermissionSchemeManager.class);
    private SubTaskManager subTaskManager;
    private WorkflowPermissionFactory workflowPermissionFactory;
    private PermissionContextFactory permissionContextFactory;
    private final EventPublisher eventPublisher;

    public WorkflowBasedPermissionSchemeManager(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, WorkflowPermissionFactory workflowPermissionFactory, PermissionContextFactory permissionContextFactory, OfBizDelegator ofBizDelegator, SchemeFactory schemeFactory, EventPublisher eventPublisher, AssociationManager associationManager, GroupManager groupManager) {
        super(projectManager, permissionTypeManager, permissionContextFactory, ofBizDelegator, schemeFactory, associationManager, groupManager, eventPublisher);
        this.workflowPermissionFactory = workflowPermissionFactory;
        this.permissionContextFactory = permissionContextFactory;
        this.eventPublisher = eventPublisher;
        this.subTaskManager = ComponentManager.getInstance().getSubTaskManager();
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
    }

    @Override
    public Collection<User> getUsers(Long permissionId, PermissionContext ctx) {
        Collection<User> users = super.getUsers(permissionId, ctx);
        if (ctx.hasIssuePermissions()) {
            List<WorkflowPermission> workflowPerms = this.workflowPermissionFactory.getWorkflowPermissions(ctx, permissionId.intValue(), false);
            if (this.subTaskManager.isSubTasksEnabled() && ctx.getIssue().getParentObject() != null) {
                PermissionContext parentCtx = this.permissionContextFactory.getPermissionContext(ctx.getIssue().getParentObject());
                workflowPerms.addAll(this.workflowPermissionFactory.getWorkflowPermissions(parentCtx, permissionId.intValue(), true));
            }
            if (workflowPerms.size() > 0) {
                HashSet allowedUsers = new HashSet(users.size());
                for (WorkflowPermission perm : workflowPerms) {
                    try {
                        Set newUsers = perm.getUsers(ctx);
                        log.info((Object)(perm + " added users: " + this.listUsers(newUsers)));
                        allowedUsers.addAll(newUsers);
                    }
                    catch (IllegalArgumentException e) {
                        log.error((Object)("Error with workflow permission" + perm + ": " + e.getMessage()), (Throwable)e);
                        throw new RuntimeException("Error with workflow permission " + perm + ": " + e.getMessage());
                    }
                }
                log.info((Object)("Retaining " + this.listUsers(allowedUsers) + " of " + this.listUsers(users)));
                users.retainAll(allowedUsers);
            }
        }
        return users;
    }

    private String listUsers(Collection newUsers) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        Iterator iterator = newUsers.iterator();
        while (iterator.hasNext()) {
            User user = (User)iterator.next();
            buf.append(user.getName());
            if (!iterator.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }
}

