/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mention.commands;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.issue.MentionIssueEvent;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.mail.MailService;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.mail.server.MailServerManager;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.log4j.Logger;

@EventComponent
public class EmailMentionedUsers {
    private Logger log = Logger.getLogger(EmailMentionedUsers.class);
    private final MailService mailService;
    private final RendererManager rendererManager;
    private final MailServerManager mailServerManager;

    public EmailMentionedUsers(MailService mailService, RendererManager rendererManager, MailServerManager mailServerManager) {
        this.rendererManager = rendererManager;
        this.mailService = mailService;
        this.mailServerManager = mailServerManager;
    }

    @EventListener
    public void execute(MentionIssueEvent mentionIssueEvent) {
        if (this.mailServerManager.isDefaultSMTPMailServerDefined()) {
            User from = mentionIssueEvent.getFromUser();
            for (User toUser : mentionIssueEvent.getToUsers()) {
                if (toUser.getEmailAddress() == null) {
                    this.log.warn((Object)("User " + toUser.getName() + " does not have a registered email address. No mentioned notification will be sent."));
                    continue;
                }
                NotificationRecipient recipient = new NotificationRecipient(toUser);
                if (mentionIssueEvent.getCurrentRecipients().contains(recipient)) continue;
                HashMap params = Maps.newHashMap();
                params.put("comment", mentionIssueEvent.getMentionText());
                String htmlComment = this.rendererManager.getRenderedContent("atlassian-wiki-renderer", mentionIssueEvent.getMentionText(), mentionIssueEvent.getIssue().getIssueRenderContext());
                params.put("htmlComment", htmlComment);
                params.put("issue", mentionIssueEvent.getIssue());
                String format = recipient.getFormat();
                String subjectTemplatePath = "templates/email/subject/issuementioned.vm";
                String bodyTemplatePath = "templates/email/" + format + "/issuementioned.vm";
                this.mailService.sendRenderedMail(from, recipient, subjectTemplatePath, bodyTemplatePath, params);
            }
        }
    }
}

