/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.worklog;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.event.issue.IssueEventDispatcher;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.worklog.TimeTrackingIssueUpdater;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraDurationUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;

public class DefaultTimeTrackingIssueUpdater
implements TimeTrackingIssueUpdater {
    private final IssueManager issueManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final JiraDurationUtils jiraDurationUtils;
    private final IssueFactory issueFactory;
    private final OfBizDelegator ofBizDelegator;

    public DefaultTimeTrackingIssueUpdater(OfBizDelegator ofBizDelegator, IssueManager issueManager, JiraAuthenticationContext jiraAuthenticationContext, JiraDurationUtils jiraDurationUtils, IssueFactory issueFactory) {
        this.ofBizDelegator = ofBizDelegator;
        this.issueManager = issueManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.jiraDurationUtils = jiraDurationUtils;
        this.issueFactory = issueFactory;
    }

    public void updateIssueOnWorklogCreate(User user, Worklog worklog, Long newEstimate, boolean dispatchEvent) {
        this.validateWorklogAndIssue(worklog);
        Issue issue = worklog.getIssue();
        GenericValue issueGV = issue.getGenericValue();
        this.setNewEstimate(newEstimate, issueGV);
        Long timeSpent = worklog.getTimeSpent();
        Long totalTimeSpent = issue.getTimeSpent();
        totalTimeSpent = totalTimeSpent == null ? timeSpent : Long.valueOf(totalTimeSpent + timeSpent);
        issueGV.set("timespent", (Object)totalTimeSpent);
        this.updateIssue(issueGV, user, null, worklog, EventType.ISSUE_WORKLOGGED_ID, this.constructChangeItemBeansForWorklogUpdateOrCreate(worklog), dispatchEvent);
    }

    public void updateIssueOnWorklogUpdate(User user, Worklog originalWorklog, Worklog newWorklog, Long originalTimeSpent, Long newEstimate, boolean dispatchEvent) {
        long newTotalTimeSpent;
        this.validateWorklogAndIssue(newWorklog);
        Issue issue = newWorklog.getIssue();
        GenericValue issueGV = issue.getGenericValue();
        this.setNewEstimate(newEstimate, issueGV);
        Long newTimeSpent = newWorklog.getTimeSpent();
        Long totalTimeSpent = issue.getTimeSpent();
        if (totalTimeSpent == null) {
            newTotalTimeSpent = newTimeSpent;
        } else {
            newTotalTimeSpent = totalTimeSpent - originalTimeSpent + newTimeSpent;
            if (newTotalTimeSpent < 0L) {
                newTotalTimeSpent = 0L;
            }
        }
        issueGV.set("timespent", (Object)newTotalTimeSpent);
        this.updateIssue(issueGV, user, originalWorklog, newWorklog, EventType.ISSUE_WORKLOG_UPDATED_ID, this.constructChangeItemBeansForWorklogUpdateOrCreate(newWorklog), dispatchEvent);
    }

    public void updateIssueOnWorklogDelete(User user, Worklog worklog, Long newEstimate, boolean dispatchEvent) {
        long newTotalTimeSpent;
        this.validateWorklogAndIssue(worklog);
        Issue issue = worklog.getIssue();
        GenericValue issueGV = issue.getGenericValue();
        this.setNewEstimate(newEstimate, issueGV);
        Long timeSpent = worklog.getTimeSpent();
        Long totalTimeSpent = issue.getTimeSpent();
        if (totalTimeSpent == null) {
            newTotalTimeSpent = 0L;
        } else {
            newTotalTimeSpent = totalTimeSpent - timeSpent;
            if (newTotalTimeSpent < 0L) {
                newTotalTimeSpent = 0L;
            }
        }
        issueGV.set("timespent", (Object)newTotalTimeSpent);
        this.updateIssue(issueGV, user, null, worklog, EventType.ISSUE_WORKLOG_DELETED_ID, this.constructChangeItemBeansForWorklogDelete(worklog), dispatchEvent);
    }

    List<ChangeItemBean> constructChangeItemBeansForWorklogDelete(Worklog worklog) {
        String message;
        String actionLevel;
        String timeSpentString = null;
        String groupLevel = worklog.getGroupLevel();
        String roleLevel = worklog.getRoleLevel() == null ? null : worklog.getRoleLevel().getName();
        String string = actionLevel = groupLevel == null ? roleLevel : groupLevel;
        if (actionLevel != null) {
            message = this.jiraAuthenticationContext.getI18nHelper().getText("time.tracking.issue.updater.deleted.worklog.with.restricted.level", actionLevel);
        } else {
            message = this.getFormattedDuration(worklog.getTimeSpent());
            timeSpentString = worklog.getTimeSpent().toString();
        }
        ChangeItemBean worklogIdBean = new ChangeItemBean("jira", "WorklogId", worklog.getId().toString(), worklog.getId().toString(), null, null);
        ChangeItemBean worklogDurationBean = new ChangeItemBean("jira", "WorklogTimeSpent", timeSpentString, message, null, null);
        return EasyList.build((Object)worklogIdBean, (Object)worklogDurationBean);
    }

    List<ChangeItemBean> constructChangeItemBeansForWorklogUpdateOrCreate(Worklog worklog) {
        ChangeItemBean worklogIdBean = new ChangeItemBean("jira", "WorklogId", worklog.getId().toString(), worklog.getId().toString(), null, null);
        return EasyList.build((Object)worklogIdBean);
    }

    String getFormattedDuration(Long duration) {
        return this.jiraDurationUtils.getFormattedDuration(duration);
    }

    void updateIssue(GenericValue issueGV, User user, Worklog originalWorklog, Worklog worklog, Long eventId, List<ChangeItemBean> changeItems, boolean dispatchEvent) {
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issueGV, this.issueManager.getIssue(issueGV.getLong("id")), eventId, user);
        issueUpdateBean.setWorklog(worklog);
        Map eventParams = EasyMap.build((Object)"level", (Object)worklog.getGroupLevel(), (Object)"rolelevel", (Object)worklog.getRoleLevelId(), (Object)"eventsource", (Object)"action");
        if (originalWorklog != null) {
            eventParams.put("originalworklog", originalWorklog);
        }
        issueUpdateBean.setParams(eventParams);
        issueUpdateBean.setDispatchEvent(dispatchEvent);
        if (changeItems != null) {
            issueUpdateBean.setChangeItems(changeItems);
        }
        this.doUpdate(issueUpdateBean);
    }

    void doUpdate(IssueUpdateBean iub) {
        GenericValue changedIssue = iub.getChangedIssue();
        changedIssue.set("updated", (Object)UtilDateTime.nowTimestamp());
        this.ofBizDelegator.storeAll(EasyList.build((Object)changedIssue));
        GenericValue changeGroup = ChangeLogUtils.createChangeGroup(iub.getUser(), iub.getOriginalIssue(), changedIssue, (Collection<ChangeItemBean>)iub.getChangeItems(), true);
        if (iub.isDispatchEvent()) {
            this.dispatchEvent(iub, changedIssue, changeGroup);
        }
    }

    void dispatchEvent(IssueUpdateBean iub, GenericValue changedIssue, GenericValue changeGroup) {
        IssueEventDispatcher.dispatchEvent(iub.getEventTypeId(), (Issue)this.issueFactory.getIssue(changedIssue), iub.getUser(), iub.getComment(), iub.getWorklog(), changeGroup, iub.getParams(), iub.isSendMail());
    }

    void setNewEstimate(Long newEstimate, GenericValue issueGV) {
        if (newEstimate != null) {
            issueGV.set("timeestimate", (Object)newEstimate);
        }
    }

    void validateWorklogAndIssue(Worklog worklog) {
        if (worklog == null) {
            throw new IllegalArgumentException("Worklog must not be null.");
        }
        if (worklog.getIssue() == null) {
            throw new IllegalArgumentException("The worklogs issue must not be null.");
        }
    }
}

