/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.issue.action.IssueActionComparator;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel2;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsReply;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelInvoker;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelReply;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class AllTabPanel
extends AbstractIssueTabPanel2 {
    private static final Logger log = Logger.getLogger(AllTabPanel.class);
    private final PluginAccessor pluginAccessor;
    private final IssueTabPanelInvoker issueTabPanelInvoker;

    public AllTabPanel(PluginAccessor pluginAccessor, IssueTabPanelInvoker issueTabPanelInvoker) {
        this.pluginAccessor = pluginAccessor;
        this.issueTabPanelInvoker = issueTabPanelInvoker;
    }

    public GetActionsReply getActions(GetActionsRequest request) {
        ArrayList allActions = Lists.newArrayList();
        List<IssueTabPanelModuleDescriptor> showTabPanels = this.getVisibleTabPanels(request);
        for (IssueTabPanelModuleDescriptor issueTabPanel : showTabPanels) {
            GetActionsReply getActionsReply = this.issueTabPanelInvoker.invokeGetActions(request, issueTabPanel);
            ImmutableList actions = getActionsReply.actions();
            if (actions == null) continue;
            for (IssueAction action : actions) {
                if (!action.isDisplayActionAllTab()) continue;
                allActions.add(action);
            }
        }
        if (allActions.isEmpty()) {
            return GetActionsReply.create((IssueAction[])new IssueAction[]{new GenericMessageAction(this.descriptor().getI18nBean().getText("viewissue.noactions"))});
        }
        Collections.sort(allActions, IssueActionComparator.COMPARATOR);
        return GetActionsReply.create((Iterable)allActions);
    }

    private List<IssueTabPanelModuleDescriptor> getVisibleTabPanels(GetActionsRequest request) {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(IssueTabPanelModuleDescriptor.class);
        ArrayList visibleTabPanels = Lists.newArrayListWithCapacity((int)descriptors.size());
        for (IssueTabPanelModuleDescriptor tabPanelDescriptor : descriptors) {
            ShowPanelReply showPanelReply = this.issueTabPanelInvoker.invokeShowPanel(new ShowPanelRequest(request.issue(), request.remoteUser()), tabPanelDescriptor);
            if (!showPanelReply.isShow() || AllTabPanel.class.isAssignableFrom(tabPanelDescriptor.getModuleClass())) continue;
            visibleTabPanels.add(tabPanelDescriptor);
        }
        return visibleTabPanels;
    }

    public ShowPanelReply showPanel(ShowPanelRequest request) {
        return ShowPanelReply.create((boolean)true);
    }
}

