/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.NavigatorStructureChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DefaultIndexedInputHelper;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class LabelsSearchInputTransformer
implements SearchInputTransformer {
    private final IndexInfoResolver<Label> indexInfoResolver;
    private final FieldFlagOperandRegistry fieldFlagOperandRegistry;
    private final JqlOperandResolver operandResolver;
    private final SearchContextVisibilityChecker searchContextVisibilityChecker;

    public LabelsSearchInputTransformer(IndexInfoResolver<Label> indexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, SearchContextVisibilityChecker searchContextVisibilityChecker) {
        this.indexInfoResolver = indexInfoResolver;
        this.fieldFlagOperandRegistry = fieldFlagOperandRegistry;
        this.operandResolver = operandResolver;
        this.searchContextVisibilityChecker = searchContextVisibilityChecker;
    }

    public void populateFromParams(User searcher, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        String url = SystemSearchConstants.forLabels().getUrlParameter();
        String values = actionParams.getFirstValueForKey(url);
        if (StringUtils.isNotBlank((String)values)) {
            String[] labels;
            ArrayList<String> cleanValues = new ArrayList<String>();
            for (String value : labels = StringUtils.split((String)values, (String)" ")) {
                cleanValues.add(value.trim());
            }
            fieldValuesHolder.put((Object)url, cleanValues);
        }
    }

    public void validateParams(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        List query = (List)fieldValuesHolder.get((Object)SystemSearchConstants.forLabels().getUrlParameter());
        if (query != null && !query.isEmpty()) {
            for (String labelString : query) {
                String[] labels;
                if (!StringUtils.isNotBlank((String)labelString)) continue;
                for (String theLabel : labels = StringUtils.split((String)labelString, (String)" ")) {
                    String label = theLabel.trim();
                    if (!LabelParser.isValidLabelName((String)label)) {
                        errors.addErrorMessage(i18nHelper.getText("label.service.error.label.invalid", label));
                    }
                    if (label.length() <= 255) continue;
                    errors.addErrorMessage(i18nHelper.getText("label.service.error.label.toolong", label));
                }
            }
        }
    }

    public void populateFromQuery(User searcher, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        Set<String> uncleanedValues = this.getNavigatorValuesAsStrings(searcher, query, searchContext);
        ArrayList<String> values = new ArrayList<String>(uncleanedValues);
        ArrayList<String> cleanValues = new ArrayList<String>();
        for (String value : values) {
            cleanValues.add(value.trim());
        }
        fieldValuesHolder.put((Object)SystemSearchConstants.forLabels().getUrlParameter(), cleanValues);
    }

    Set<String> getNavigatorValuesAsStrings(User searcher, Query query, SearchContext searchContext) {
        DefaultIndexedInputHelper helper = new DefaultIndexedInputHelper(this.indexInfoResolver, this.operandResolver, this.fieldFlagOperandRegistry, this.searchContextVisibilityChecker);
        return helper.getAllNavigatorValuesForMatchingClauses(searcher, SystemSearchConstants.forLabels().getJqlClauseNames(), query, searchContext);
    }

    public boolean doRelevantClausesFitFilterForm(User searcher, Query query, SearchContext searchContext) {
        return this.createNavigatorStructureChecker().checkSearchRequest(query, searchContext);
    }

    private NavigatorStructureChecker<Label> createNavigatorStructureChecker() {
        return new NavigatorStructureChecker(SystemSearchConstants.forLabels().getJqlClauseNames(), false, this.fieldFlagOperandRegistry, this.operandResolver, this.indexInfoResolver, this.searchContextVisibilityChecker);
    }

    public Clause getSearchClause(User searcher, FieldValuesHolder fieldValuesHolder) {
        List labels = (List)fieldValuesHolder.get((Object)SystemSearchConstants.forLabels().getUrlParameter());
        if (labels != null && !labels.isEmpty()) {
            if (labels.size() == 1) {
                String sanitizedLabel = ((String)labels.get(0)).trim();
                return new TerminalClauseImpl(SystemSearchConstants.forLabels().getJqlClauseNames().getPrimaryName(), Operator.EQUALS, (Operand)new SingleValueOperand(sanitizedLabel));
            }
            ArrayList<SingleValueOperand> operands = new ArrayList<SingleValueOperand>();
            for (String label : labels) {
                String sanitizedLabel = label.trim();
                operands.add(new SingleValueOperand(sanitizedLabel.trim()));
            }
            return new TerminalClauseImpl(SystemSearchConstants.forLabels().getJqlClauseNames().getPrimaryName(), Operator.IN, (Operand)new MultiValueOperand(operands));
        }
        return null;
    }
}

