/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.impl;

import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.index.indexers.impl.ReporterIndexer;
import com.atlassian.jira.issue.search.KickassSearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.impl.AbstractInitializationSearcher;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.ReporterSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.KickassUserSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.UserSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.UserFitsNavigatorHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;

public class ReporterSearcher
extends AbstractInitializationSearcher
implements IssueSearcher<SearchableField> {
    public static final String NAME_KEY = "navigator.filter.reportedby";
    final SearcherInformation<SearchableField> searcherInformation;
    final SearchRenderer searchRenderer;
    final SearchInputTransformer searchInputTransformer;
    final KickassUserSearchInputTransformer kickassSearchInputTransformer;

    public ReporterSearcher(VelocityRequestContextFactory velocityRequestContextFactory, VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, UserPickerSearchService userPickerSearchService, GroupManager groupManager, UserManager userManager, UserUtil userUtil, PermissionManager permissionManager, FieldVisibilityManager fieldVisibilityManager) {
        UserFieldSearchConstantsWithEmpty searchConstants = SystemSearchConstants.forReporter();
        UserFitsNavigatorHelper userFitsNavigatorHelper = new UserFitsNavigatorHelper(userPickerSearchService);
        this.searcherInformation = new GenericSearcherInformation(searchConstants.getSearcherId(), NAME_KEY, Collections.singletonList(ReporterIndexer.class), this.fieldReference, SearcherGroupType.ISSUE);
        this.searchRenderer = new ReporterSearchRenderer(NAME_KEY, velocityRequestContextFactory, applicationProperties, templatingEngine, userPickerSearchService, userManager, userUtil, groupManager, permissionManager, fieldVisibilityManager);
        this.searchInputTransformer = new UserSearchInputTransformer(searchConstants, userFitsNavigatorHelper, groupManager, userManager);
        this.kickassSearchInputTransformer = new KickassUserSearchInputTransformer(searchConstants, userFitsNavigatorHelper, groupManager, userManager);
    }

    public SearcherInformation<SearchableField> getSearchInformation() {
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        KickassSearchContext kickassSearchContext = (KickassSearchContext)ComponentAccessor.getComponent(KickassSearchContext.class);
        if (kickassSearchContext.isEnabled()) {
            return this.kickassSearchInputTransformer;
        }
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        return this.searchRenderer;
    }
}

