/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.filters;

import java.io.IOException;
import java.util.BitSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.DocIdBitSet;

public class IssueIdFilter
extends Filter {
    private final Set<String> issuesIds;

    public IssueIdFilter(Set<String> issuesIds) {
        this.issuesIds = issuesIds;
    }

    public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
        BitSet bits = new BitSet(indexReader.maxDoc());
        int[] docs = new int[1];
        int[] freqs = new int[1];
        for (String issueId : this.issuesIds) {
            TermDocs termDocs;
            int count;
            if (issueId == null || (count = (termDocs = indexReader.termDocs(new Term("issue_id", issueId))).read(docs, freqs)) <= 0) continue;
            bits.set(docs[0]);
        }
        return new DocIdBitSet(bits);
    }
}

