/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.jira.web.session.SessionSearchObjectManagerFactory;
import com.atlassian.jira.web.session.SessionSearchRequestManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CurrentSearchLinkFactory
implements SimpleLinkFactory {
    private static final int MAX_MENU_LABEL_LENGTH = 30;
    private static final Logger log = Logger.getLogger(CurrentSearchLinkFactory.class);
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final I18nHelper.BeanFactory i18nFactory;
    private final SearchProvider searchProvider;
    private final SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory;

    public CurrentSearchLinkFactory(VelocityRequestContextFactory velocityRequestContextFactory, I18nHelper.BeanFactory i18nFactory, SearchProvider searchProvider, SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.i18nFactory = i18nFactory;
        this.searchProvider = searchProvider;
        this.sessionSearchObjectManagerFactory = sessionSearchObjectManagerFactory;
    }

    public void init(SimpleLinkFactoryModuleDescriptor descriptor) {
    }

    public List<SimpleLink> getLinks(User user, Map<String, Object> params) {
        VelocityRequestContext velocityRequestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        ArrayList<SimpleLink> links = new ArrayList<SimpleLink>(1);
        SearchRequest searchRequest = this.getSearchRequest(velocityRequestContext);
        if (searchRequest != null) {
            String name;
            I18nHelper i18n = this.i18nFactory.getInstance(user);
            long count = -1L;
            try {
                count = this.searchProvider.searchCount(searchRequest.getQuery(), user);
            }
            catch (SearchException e) {
                log.warn((Object)"Error thrown while getting count for current search.", (Throwable)e);
            }
            String baseUrl = velocityRequestContext.getBaseUrl();
            String shortName = name = this.getName(i18n, searchRequest);
            if (name.length() > 30) {
                shortName = shortName.substring(0, 30) + "...";
            }
            String display = this.getFilterDisplay(i18n, shortName, searchRequest, count);
            String title = StringUtils.isBlank((String)searchRequest.getDescription()) ? name : i18n.getText("menu.issues.current.search.title", name, searchRequest.getDescription());
            links.add((SimpleLink)new SimpleLinkImpl("curr_search_lnk_" + this.getId(searchRequest), display, title, null, null, null, baseUrl + "/secure/IssueNavigator.jspa?mode=hide", null));
        }
        return links;
    }

    private String getId(SearchRequest searchRequest) {
        return searchRequest.isLoaded() ? searchRequest.getId().toString() : "unsaved";
    }

    private String getName(I18nHelper i18n, SearchRequest searchRequest) {
        return searchRequest.isLoaded() ? searchRequest.getName() : i18n.getText("menu.issues.current.search.unsaved");
    }

    private String getFilterDisplay(I18nHelper i18n, String name, SearchRequest searchRequest, long count) {
        if (count == 0L) {
            return i18n.getText("menu.issues.current.search.no.issues", name);
        }
        if (count == 1L) {
            return i18n.getText("menu.issues.current.search.one.issue", name);
        }
        if (count > 1L) {
            return i18n.getText("menu.issues.current.search.issues", name, count + "");
        }
        return name;
    }

    private SearchRequest getSearchRequest(VelocityRequestContext velocityRequestContext) {
        VelocityRequestSession session;
        if (velocityRequestContext != null && (session = velocityRequestContext.getSession()) != null) {
            SessionSearchRequestManager sessionSearchRequestManager = this.sessionSearchObjectManagerFactory.createSearchRequestManager(session);
            return (SearchRequest)sessionSearchRequestManager.getCurrentObject();
        }
        return null;
    }
}

