/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.concurrent.Barrier;
import com.atlassian.jira.concurrent.BarrierFactory;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.config.ReindexMessage;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.IndexingConfiguration;
import com.atlassian.jira.entityengine.FindOptions;
import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.event.listeners.search.IssueIndexListener;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.IndexConsistencyUtils;
import com.atlassian.jira.issue.index.IndexDeactivatedEvent;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IndexingShutdownEvent;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.issue.index.JiraAnalyzer;
import com.atlassian.jira.issue.index.ReindexAllCancelledEvent;
import com.atlassian.jira.issue.index.ReindexAllCompletedEvent;
import com.atlassian.jira.issue.index.ReindexAllStartedEvent;
import com.atlassian.jira.issue.index.ReindexIssuesCompletedEvent;
import com.atlassian.jira.issue.index.ReindexIssuesStartedEvent;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.index.SearcherCache;
import com.atlassian.jira.issue.util.DatabaseIssuesIterable;
import com.atlassian.jira.issue.util.IssueGVsIssueIterable;
import com.atlassian.jira.issue.util.IssueObjectIssuesIterable;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class DefaultIndexManager
implements IssueIndexManager {
    private static final Logger log = Logger.getLogger(DefaultIndexManager.class);
    private static final String BATCH_SIZE_PROPERTY_NAME = "jira.index.background.batch.size";
    private static final int BATCH_SIZE_DEFAULT_VALUE = 1000;
    public static final Analyzer ANALYZER_FOR_SEARCHING = JiraAnalyzer.ANALYZER_FOR_SEARCHING;
    public static final Analyzer ANALYZER_FOR_INDEXING = JiraAnalyzer.ANALYZER_FOR_INDEXING;
    public static final String COMMENTS_SUBDIR = "comments";
    public static final String ISSUES_SUBDIR = "issues";
    public static final String PLUGINS_SUBDIR = "plugins";
    private final IndexLocks indexLock = new IndexLocks();
    private final IssueIndexer issueIndexer;
    private final IndexPathManager indexPathManager;
    private final IndexingConfiguration indexConfig;
    private final ReindexMessageManager reindexMessageManager;
    private final EventPublisher eventPublisher;
    private final ListenerManager listenerManager;
    private final ProjectManager projectManager;
    private final FeatureManager featureManager;
    private final TaskManager taskManager;
    private final ApplicationProperties applicationProperties;
    private final Barrier backgroundReindexBarrier;
    private final ThreadLocal<Boolean> indexingHeld = new ThreadLocal();
    private final ThreadLocal<Set<Issue>> heldIssues = new ThreadLocal<Set<Issue>>(){

        @Override
        protected Set<Issue> initialValue() {
            return new HashSet<Issue>();
        }
    };
    private final Supplier<IndexSearcher> issueSearcherSupplier = new Supplier<IndexSearcher>(){

        public IndexSearcher get() {
            try {
                return DefaultIndexManager.this.issueIndexer.getIssueSearcher();
            }
            catch (RuntimeException e) {
                throw new SearchUnavailableException(e, DefaultIndexManager.this.indexConfig.isIndexingEnabled());
            }
        }
    };
    private final Supplier<IndexSearcher> commentSearcherSupplier = new Supplier<IndexSearcher>(){

        public IndexSearcher get() {
            try {
                return DefaultIndexManager.this.issueIndexer.getCommentSearcher();
            }
            catch (RuntimeException e) {
                throw new SearchUnavailableException(e, DefaultIndexManager.this.indexConfig.isIndexingEnabled());
            }
        }
    };
    private final Supplier<IndexSearcher> changeHistorySearcherSupplier = new Supplier<IndexSearcher>(){

        public IndexSearcher get() {
            try {
                return DefaultIndexManager.this.issueIndexer.getChangeHistorySearcher();
            }
            catch (RuntimeException e) {
                throw new SearchUnavailableException(e, DefaultIndexManager.this.indexConfig.isIndexingEnabled());
            }
        }
    };

    public Analyzer getAnalyzerForSearching() {
        return ANALYZER_FOR_SEARCHING;
    }

    public Analyzer getAnalyzerForIndexing() {
        return ANALYZER_FOR_INDEXING;
    }

    public DefaultIndexManager(IndexingConfiguration indexProperties, IssueIndexer issueIndexer, IndexPathManager indexPath, ReindexMessageManager reindexMessageManager, EventPublisher eventPublisher, ListenerManager listenerManager, ProjectManager projectManager, FeatureManager featureManager, BarrierFactory barrierFactory, TaskManager taskManager, ApplicationProperties applicationProperties) {
        this.featureManager = featureManager;
        this.taskManager = taskManager;
        this.applicationProperties = applicationProperties;
        this.eventPublisher = (EventPublisher)Assertions.notNull((String)"eventPublisher", (Object)eventPublisher);
        this.indexConfig = (IndexingConfiguration)Assertions.notNull((String)"indexProperties", (Object)indexProperties);
        this.issueIndexer = (IssueIndexer)Assertions.notNull((String)"issueIndexer", (Object)issueIndexer);
        this.indexPathManager = (IndexPathManager)Assertions.notNull((String)"indexPath", (Object)indexPath);
        this.reindexMessageManager = (ReindexMessageManager)Assertions.notNull((String)"reindexMessageManager", (Object)reindexMessageManager);
        this.listenerManager = listenerManager;
        this.projectManager = projectManager;
        this.backgroundReindexBarrier = barrierFactory.getBarrier("backgroundReindex");
    }

    public void deactivate() {
        this.listenerManager.deleteListener(IssueIndexListener.class);
        this.indexConfig.disableIndexing();
        this.issueIndexer.shutdown();
        DefaultIndexManager.flushThreadLocalSearchers();
        this.eventPublisher.publish((Object)new IndexDeactivatedEvent());
    }

    public long activate(Context context) {
        Assertions.notNull((String)"context", (Object)context);
        if (this.isIndexingEnabled()) {
            throw new IllegalStateException("Cannot activate indexing as it is already active.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Activating indexes in '" + this.indexPathManager.getIndexRootPath() + "'."));
        }
        this.listenerManager.createListener("Issue Index Listener", IssueIndexListener.class);
        this.indexConfig.enableIndexing();
        return this.reIndexAll(context);
    }

    public boolean isIndexingEnabled() {
        return this.indexConfig.isIndexingEnabled();
    }

    public long reIndexAll() throws IndexException {
        return this.reIndexAll(Contexts.nullContext());
    }

    public long reIndexAll(Context context) {
        return this.reIndexAll(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reIndexAll(Context context, boolean useBackgroundIndexing) {
        Assertions.notNull((String)"context", (Object)context);
        context.setName("Issue");
        log.info((Object)"Reindexing all issues");
        this.eventPublisher.publish((Object)new ReindexAllStartedEvent());
        long startTime = System.currentTimeMillis();
        ReindexMessage message = this.reindexMessageManager.getMessageObject();
        if (useBackgroundIndexing) {
            try {
                this.doBackgroundReindex(context);
            }
            catch (InterruptedException e) {
                this.eventPublisher.publish((Object)new ReindexAllCancelledEvent());
                return -1L;
            }
        }
        if (!this.indexLock.writeLock.tryLock()) {
            return -1L;
        }
        try {
            this.doStopTheWorldReindex(context);
        }
        finally {
            this.indexLock.writeLock.unlock();
            DefaultIndexManager.flushThreadLocalSearchers();
        }
        if (message != null) {
            this.reindexMessageManager.clearMessageForTimestamp(message.getTime());
        }
        long totalTime = System.currentTimeMillis() - startTime;
        if (log.isDebugEnabled()) {
            log.debug((Object)("ReindexAll took : " + totalTime + "ms"));
        }
        this.eventPublisher.publish((Object)new ReindexAllCompletedEvent(totalTime));
        return totalTime;
    }

    public long reIndexAllIssuesInBackground(Context context) {
        return this.reIndexAll(context, true);
    }

    public long reIndexIssues(Collection<GenericValue> issues) throws IndexException {
        return this.reIndexIssues(new IssueGVsIssueIterable(issues, this.getIssueFactory()), Contexts.nullContext());
    }

    protected long reIndexIssues(Collection<GenericValue> issues, boolean reIndexComments, boolean reIndexChangeHistory) throws IndexException {
        return this.reIndexIssues(new IssueGVsIssueIterable(issues, this.getIssueFactory()), Contexts.nullContext(), reIndexComments, reIndexChangeHistory);
    }

    public long reIndexIssueObjects(Collection<? extends Issue> issueObjects) throws IndexException {
        return this.reIndexIssueObjects(issueObjects, true, true);
    }

    public long reIndexIssueObjects(Collection<? extends Issue> issueObjects, boolean reIndexComments, boolean reIndexChangeHistory) throws IndexException {
        Collection genericValues = CollectionUtils.collect(issueObjects, (Transformer)IssueFactory.TO_GENERIC_VALUE);
        return this.reIndexIssues(genericValues, reIndexComments, reIndexChangeHistory);
    }

    public void reIndex(Issue issue) throws IndexException {
        this.reIndex(issue, true, true);
    }

    public void reIndex(Issue issue, boolean reIndexComments, boolean reIndexChangeHistory) throws IndexException {
        ArrayList issues = Lists.newArrayList((Object[])new Issue[]{issue});
        this.reIndexIssueObjects(issues, reIndexComments, reIndexChangeHistory);
    }

    public void reIndex(GenericValue issueGV) throws IndexException {
        if ("Issue".equals(issueGV.getEntityName())) {
            ArrayList genericValues = Lists.newArrayList((Object[])new GenericValue[]{issueGV});
            this.reIndexIssues(genericValues);
        } else {
            log.error((Object)("Entity is not an issue " + issueGV.getEntityName()));
        }
    }

    public void hold() {
        this.indexingHeld.set(Boolean.TRUE);
    }

    public boolean isHeld() {
        return this.indexingHeld.get() != null && this.indexingHeld.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long release() throws IndexException {
        this.indexingHeld.set(Boolean.FALSE);
        try {
            Set<Issue> queue = this.heldIssues.get();
            if (queue.size() > 0) {
                IssueObjectIssuesIterable issuesIterable = new IssueObjectIssuesIterable(queue);
                long l = this.reIndexIssues(issuesIterable, Contexts.nullContext());
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.heldIssues.remove();
            this.indexingHeld.remove();
        }
    }

    public long reIndexIssues(IssuesIterable issuesIterable, Context context) throws IndexException {
        return this.reIndexIssues(issuesIterable, context, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reIndexIssues(IssuesIterable issuesIterable, Context context, boolean reIndexComments, boolean reIndexChangeHistory) throws IndexException {
        if (this.isHeld()) {
            final Set<Issue> queue = this.heldIssues.get();
            issuesIterable.foreach((Consumer)new Consumer<Issue>(){

                public void consume(@NotNull Issue element) {
                    queue.add(element);
                }
            });
            return 0L;
        }
        Assertions.notNull((String)ISSUES_SUBDIR, (Object)issuesIterable);
        Assertions.notNull((String)"context", (Object)context);
        this.eventPublisher.publish((Object)new ReindexIssuesStartedEvent());
        OpTimer opTimer = Instrumentation.pullTimer(InstrumentationName.ISSUE_INDEX_WRITES);
        if (!this.getIndexLock()) {
            log.error((Object)("Could not reindex: " + issuesIterable.toString()));
            return -1L;
        }
        try {
            this.await(this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)issuesIterable, context, reIndexComments, reIndexChangeHistory, false));
        }
        finally {
            this.releaseIndexLock();
            DefaultIndexManager.flushThreadLocalSearchers();
            opTimer.end();
        }
        long totalTime = opTimer.snapshot().getMillisecondsTaken();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reindexed " + issuesIterable.size() + " issues in " + totalTime + "ms."));
        }
        this.eventPublisher.publish((Object)new ReindexIssuesCompletedEvent(totalTime));
        return totalTime;
    }

    public long reIndexComments(Collection<Comment> comments) throws IndexException {
        return this.reIndexComments(comments, Contexts.nullContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reIndexComments(Collection<Comment> comments, Context context) throws IndexException {
        Assertions.notNull((String)COMMENTS_SUBDIR, comments);
        Assertions.notNull((String)"context", (Object)context);
        this.eventPublisher.publish((Object)new ReindexIssuesStartedEvent());
        OpTimer opTimer = Instrumentation.pullTimer(InstrumentationName.ISSUE_INDEX_WRITES);
        if (!this.getIndexLock()) {
            log.error((Object)("Could not reindex: " + comments.toString()));
            return -1L;
        }
        try {
            this.await(this.issueIndexer.reindexComments(comments, context));
        }
        finally {
            this.releaseIndexLock();
            DefaultIndexManager.flushThreadLocalSearchers();
            opTimer.end();
        }
        long totalTime = opTimer.snapshot().getMillisecondsTaken();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reindexed " + comments.size() + " comments in " + totalTime + "ms."));
        }
        this.eventPublisher.publish((Object)new ReindexIssuesCompletedEvent(totalTime));
        return totalTime;
    }

    private int getCommentCount() {
        EntityFieldMap condition = new EntityFieldMap(EasyMap.build((Object)"type", (Object)"comment"), EntityOperator.AND);
        List commentCount = ComponentAccessor.getOfBizDelegator().findByCondition("ActionCount", (EntityCondition)condition, (Collection)EasyList.build((Object)"count"), Collections.emptyList());
        if (commentCount != null && commentCount.size() == 1) {
            GenericValue commentCountGV = (GenericValue)commentCount.get(0);
            return commentCountGV.getLong("count").intValue();
        }
        throw new DataAccessException("Unable to access the count for the Action table");
    }

    public boolean isIndexConsistent() {
        try {
            return IndexConsistencyUtils.isIndexConsistent("Issue", this.size(), this.issueSearcherSupplier) && IndexConsistencyUtils.isIndexConsistent("Comment", this.getCommentCount(), this.commentSearcherSupplier) && IndexConsistencyUtils.isIndexConsistent("ChangeHistory", -1, this.changeHistorySearcherSupplier);
        }
        catch (Exception ex) {
            log.warn((Object)("Exception during index consistency check: " + ex));
            return false;
        }
    }

    public int size() {
        return new DatabaseIssuesIterable(ComponentAccessor.getOfBizDelegator(), this.getIssueFactory()).size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long optimize() {
        if (!this.isIndexingEnabled()) {
            return 0L;
        }
        if (!this.getIndexLock()) {
            return -1L;
        }
        try {
            long l = this.optimize0();
            return l;
        }
        finally {
            this.releaseIndexLock();
        }
    }

    @GuardedBy(value="index read lock")
    private long optimize0() {
        long startTime = System.currentTimeMillis();
        this.issueIndexer.optimize().await();
        return System.currentTimeMillis() - startTime;
    }

    public void deIndex(Issue issue) throws IndexException {
        this.deIndex(issue.getGenericValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deIndex(GenericValue entity) throws IndexException {
        if (!"Issue".equals(entity.getEntityName())) {
            log.error((Object)("Entity is not an issue " + entity.getEntityName()));
            return;
        }
        if (!this.getIndexLock()) {
            log.error((Object)("Could not deindex: " + entity.getString("key")));
            return;
        }
        try {
            ArrayList genericValues = Lists.newArrayList((Object[])new GenericValue[]{entity});
            this.await(this.issueIndexer.deindexIssues((EnclosedIterable<Issue>)new IssueGVsIssueIterable(genericValues, this.getIssueFactory()), Contexts.nullContext()));
        }
        finally {
            this.releaseIndexLock();
            DefaultIndexManager.flushThreadLocalSearchers();
        }
    }

    private void await(final Index.Result result) {
        this.obtain(new Awaitable(){

            @Override
            public boolean await(long time, TimeUnit unit) throws InterruptedException {
                return result.await(time, unit);
            }
        });
    }

    private void releaseIndexLock() {
        this.indexLock.readLock.unlock();
    }

    boolean getIndexLock() {
        if (StringUtils.isBlank((String)this.indexPathManager.getIndexRootPath())) {
            log.error((Object)"File path not set - not indexing");
            return false;
        }
        return this.indexLock.readLock.tryLock();
    }

    private boolean obtain(Awaitable waitFor) {
        try {
            if (waitFor.await(this.indexConfig.getIndexLockWaitTime(), TimeUnit.MILLISECONDS)) {
                return true;
            }
        }
        catch (InterruptedException ie) {
            log.error((Object)"Wait attempt interrupted.", (Throwable)new IndexException("Wait attempt interrupted.", (Exception)ie));
            return false;
        }
        String errorMessage = "Wait attempt timed out - waited " + this.indexConfig.getIndexLockWaitTime() + " milliseconds";
        log.error((Object)errorMessage, (Throwable)new IndexException(errorMessage));
        return false;
    }

    public String getPluginsRootPath() {
        return this.indexPathManager.getPluginIndexRootPath();
    }

    public List<String> getExistingPluginsPaths() {
        String[] listing;
        File pluginRootPath = new File(this.getPluginsRootPath());
        if (pluginRootPath.exists() && pluginRootPath.isDirectory() && pluginRootPath.canRead() && (listing = pluginRootPath.list()) != null) {
            ArrayList<String> subdirs = new ArrayList<String>();
            for (String element : listing) {
                File f = new File(pluginRootPath, element);
                if (!f.exists() || !f.canRead() || !f.isDirectory()) continue;
                subdirs.add(f.getAbsolutePath());
            }
            return Collections.unmodifiableList(subdirs);
        }
        return Collections.emptyList();
    }

    public Collection<String> getAllIndexPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(this.issueIndexer.getIndexPaths());
        paths.addAll(this.getExistingPluginsPaths());
        return Collections.unmodifiableList(paths);
    }

    public IndexSearcher getIssueSearcher() {
        return SearcherCache.getThreadLocalCache().retrieveIssueSearcher(this.issueSearcherSupplier);
    }

    public IndexSearcher getCommentSearcher() {
        return SearcherCache.getThreadLocalCache().retrieveCommentSearcher(this.commentSearcherSupplier);
    }

    public IndexSearcher getChangeHistorySearcher() {
        return SearcherCache.getThreadLocalCache().retrieveChangeHistorySearcher(this.changeHistorySearcherSupplier);
    }

    public void shutdown() {
        this.eventPublisher.publish((Object)new IndexingShutdownEvent());
        DefaultIndexManager.flushThreadLocalSearchers();
        this.issueIndexer.shutdown();
    }

    IssueFactory getIssueFactory() {
        return ComponentManager.getComponentInstanceOfType(IssueFactory.class);
    }

    public String toString() {
        return "DefaultIndexManager: paths: " + this.getAllIndexPaths();
    }

    private void doBackgroundReindex(Context context) throws InterruptedException {
        IssueIdBatcher batcher = new IssueIdBatcher();
        for (IssuesIterable batchOfIssues : batcher) {
            TaskDescriptor currentTaskDescriptor = this.taskManager.getLiveTask(new IndexTaskContext());
            if (currentTaskDescriptor.isCancelled()) {
                throw new InterruptedException();
            }
            this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)batchOfIssues, context, false, false, true).await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStopTheWorldReindex(Context context) {
        Scheduler scheduler = ComponentAccessor.getScheduler();
        boolean restartScheduler = false;
        try {
            try {
                if (!scheduler.isShutdown() && !scheduler.isPaused()) {
                    scheduler.pause();
                    restartScheduler = true;
                }
            }
            catch (SchedulerException e) {
                log.warn((Object)"The scheduler is not available, unable to pause it before reindexing.", (Throwable)e);
            }
            this.issueIndexer.deleteIndexes();
            this.doIndexIssuesInBatchMode(context);
            this.optimize0();
        }
        finally {
            if (restartScheduler) {
                try {
                    scheduler.start();
                }
                catch (SchedulerException e) {
                    log.error((Object)"Unable to unpause the scheduler after reindex", (Throwable)e);
                }
            }
        }
    }

    private void doIndexIssuesInBatchMode(Context context) {
        IssuesBatcher batcher = this.featureManager.isEnabled(CoreFeatures.BACKGROUND_REINDEX) ? new IssueIdBatcher() : new ProjectBatcher();
        for (IssuesIterable batchOfIssues : batcher) {
            this.issueIndexer.indexIssuesBatchMode((EnclosedIterable<Issue>)batchOfIssues, context).await();
        }
    }

    public static void flushThreadLocalSearchers() {
        try {
            SearcherCache.getThreadLocalCache().closeSearchers();
        }
        catch (IOException e) {
            log.error((Object)("Error while resetting searcher: " + e), (Throwable)e);
        }
    }

    private int getConfiguredBatchSize() {
        return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)BATCH_SIZE_PROPERTY_NAME, (int)1000);
    }

    private final class IndexLock {
        @Nonnull
        private final Lock lock;

        private IndexLock(Lock lock) {
            this.lock = (Lock)Preconditions.checkNotNull((Object)lock, (Object)"lock");
        }

        public boolean tryLock() {
            return DefaultIndexManager.this.obtain(new Awaitable(){

                @Override
                public boolean await(long time, TimeUnit unit) throws InterruptedException {
                    return IndexLock.this.lock.tryLock(time, unit);
                }
            });
        }

        public void unlock() {
            this.lock.unlock();
        }
    }

    private class IndexLocks {
        private final ReadWriteLock indexLock = new ReentrantReadWriteLock();
        @Nonnull
        final IndexLock readLock = new IndexLock(this.indexLock.readLock());
        @Nonnull
        final IndexLock writeLock = new IndexLock(this.indexLock.writeLock());

        private IndexLocks() {
        }
    }

    class IssueIdBatcher
    implements IssuesBatcher {
        private final OfBizDelegator delegator;
        private final IssueFactory issueFactory;
        private final int batchSize;
        private final ImmutableList<String> orderBy = ImmutableList.of((Object)"id DESC");
        private final long maxId;
        private long maxIdNextBatch;

        public IssueIdBatcher() {
            this(defaultIndexManager.getConfiguredBatchSize());
        }

        public IssueIdBatcher(int batchSize) {
            this(ComponentAccessor.getOfBizDelegator(), defaultIndexManager.getIssueFactory(), batchSize);
        }

        @VisibleForTesting
        public IssueIdBatcher(OfBizDelegator delegator, IssueFactory issueFactory, int batchSize) {
            this.delegator = delegator;
            this.issueFactory = issueFactory;
            this.batchSize = batchSize;
            this.maxIdNextBatch = this.maxId = this.selectMaxId();
        }

        @Override
        public Iterator<IssuesIterable> iterator() {
            return new IssuesIterator();
        }

        private long selectMaxId() {
            GenericValue maxGV = EntityUtil.getOnly((List)this.delegator.findByCondition("IssueMaxId", null, (Collection)ImmutableList.of((Object)"max")));
            if (maxGV == null) {
                return -1L;
            }
            Long max = maxGV.getLong("max");
            return max != null ? max : -1L;
        }

        private class SpyingIssuesIterable
        extends DatabaseIssuesIterable {
            SpyingIssuesIterable(OfBizDelegator delegator, @Nullable IssueFactory issueFactory, @Nullable EntityCondition condition, @Nullable List<String> orderBy, EntityFindOptions findOptions) {
                super(delegator, issueFactory, condition, orderBy, findOptions);
            }

            @Override
            protected void spy(Issue next) {
                DefaultIndexManager.this.backgroundReindexBarrier.await();
                IssueIdBatcher.this.maxIdNextBatch = Math.min(IssueIdBatcher.this.maxIdNextBatch, next.getId() - 1L);
            }
        }

        private class IssuesIterator
        extends AbstractIterator<IssuesIterable> {
            private IssuesIterator() {
            }

            protected IssuesIterable computeNext() {
                if (IssueIdBatcher.this.maxIdNextBatch < 0L) {
                    return (IssuesIterable)this.endOfData();
                }
                EntityExpr where = new EntityExpr("id", EntityOperator.LESS_THAN_EQUAL_TO, (Object)IssueIdBatcher.this.maxIdNextBatch);
                IssueIdBatcher.this.maxIdNextBatch -= IssueIdBatcher.this.batchSize;
                return new SpyingIssuesIterable(IssueIdBatcher.this.delegator, IssueIdBatcher.this.issueFactory, (EntityCondition)where, (List<String>)IssueIdBatcher.this.orderBy, FindOptions.findOptions().maxResults(IssueIdBatcher.this.batchSize));
            }
        }
    }

    class ProjectBatcher
    implements IssuesBatcher {
        private final OfBizDelegator delegator;
        private final ImmutableList<Project> projects;
        private final IssueFactory issueFactory;

        ProjectBatcher() {
            this(ComponentAccessor.getOfBizDelegator(), defaultIndexManager.getIssueFactory());
        }

        @VisibleForTesting
        ProjectBatcher(OfBizDelegator delegator, IssueFactory issueFactory) {
            this.delegator = delegator;
            this.issueFactory = issueFactory;
            this.projects = ImmutableList.copyOf((Collection)DefaultIndexManager.this.projectManager.getProjectObjects());
        }

        @Override
        public Iterator<IssuesIterable> iterator() {
            return new ProjectsIterator();
        }

        class ProjectsIterator
        extends AbstractIterator<IssuesIterable> {
            private final UnmodifiableIterator<Project> projectsIt;

            ProjectsIterator() {
                this.projectsIt = ProjectBatcher.this.projects.iterator();
            }

            protected IssuesIterable computeNext() {
                if (!this.projectsIt.hasNext()) {
                    return (IssuesIterable)this.endOfData();
                }
                Project project = (Project)this.projectsIt.next();
                EntityExpr condition = new EntityExpr("project", EntityOperator.EQUALS, (Object)project.getId());
                return new DatabaseIssuesIterable(ProjectBatcher.this.delegator, ProjectBatcher.this.issueFactory, (EntityCondition)condition);
            }
        }
    }

    private static interface Awaitable {
        public boolean await(long var1, TimeUnit var3) throws InterruptedException;
    }
}

