/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.history;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.history.AbstractDateRangeBuilder;
import org.apache.log4j.Logger;

public class PriorityDateRangeBuilder
extends AbstractDateRangeBuilder {
    private static final Logger log = Logger.getLogger(PriorityDateRangeBuilder.class);
    private static final String EMPTY_VALUE = "-1";

    public PriorityDateRangeBuilder() {
        this("priority", EMPTY_VALUE);
    }

    public PriorityDateRangeBuilder(String field, String emptyValue) {
        super(field, emptyValue);
    }

    @Override
    protected ChangeHistoryItem createInitialChangeItem(Issue issue) {
        String priorityName = issue.getPriorityObject() == null ? null : issue.getPriorityObject().getName();
        String priorityValue = issue.getPriorityObject() == null ? EMPTY_VALUE : issue.getPriorityObject().getId();
        return new ChangeHistoryItem.Builder().withId(-1L).inChangeGroup(-1L).forIssue(issue.getId(), issue.getKey()).inProject(issue.getProjectObject().getId()).field(this.getField()).on(issue.getCreated()).to(priorityName, priorityValue).byUser(issue.getReporter() == null ? "issue_no_reporter" : issue.getReporter().getName()).build();
    }
}

