/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import java.util.HashMap;
import java.util.Map;
import webwork.action.Action;

public class FieldScreenRenderLayoutItemImpl
implements FieldScreenRenderLayoutItem {
    private final FieldLayoutItem fieldLayoutItem;
    private final FieldScreenLayoutItem fieldScreenLayoutItem;

    public FieldScreenRenderLayoutItemImpl(FieldScreenLayoutItem fieldScreenLayoutItem, FieldLayoutItem fieldLayoutItem) {
        this.fieldScreenLayoutItem = fieldScreenLayoutItem;
        this.fieldLayoutItem = fieldLayoutItem;
    }

    public OrderableField getOrderableField() {
        return this.fieldLayoutItem.getOrderableField();
    }

    public String getEditHtml(Action action, OperationContext operationContext, Issue issue) {
        return this.getEditHtml(action, operationContext, issue, new HashMap<String, Object>());
    }

    public String getCreateHtml(Action action, OperationContext operationContext, Issue issue) {
        return this.getCreateHtml(action, operationContext, issue, new HashMap<String, Object>());
    }

    public String getViewHtml(Action action, OperationContext operationContext, Issue issue) {
        return this.getViewHtml(action, operationContext, issue, new HashMap<String, Object>());
    }

    public String getCreateHtml(Action action, OperationContext operationContext, Issue issue, Map<String, Object> displayParams) {
        if (this.isShow(issue)) {
            return this.fieldScreenLayoutItem.getCreateHtml(this.fieldLayoutItem, operationContext, action, issue, displayParams);
        }
        return "";
    }

    public String getEditHtml(Action action, OperationContext operationContext, Issue issue, Map<String, Object> displayParams) {
        if (this.isShow(issue)) {
            return this.fieldScreenLayoutItem.getEditHtml(this.fieldLayoutItem, operationContext, action, issue, displayParams);
        }
        return "";
    }

    public String getViewHtml(Action action, OperationContext operationContext, Issue issue, Map<String, Object> displayParams) {
        if (this.isShow(issue)) {
            return this.fieldScreenLayoutItem.getViewHtml(this.fieldLayoutItem, operationContext, action, issue, displayParams);
        }
        return "";
    }

    public boolean isShow(Issue issue) {
        return !this.fieldLayoutItem.isHidden() && this.fieldScreenLayoutItem != null && this.fieldScreenLayoutItem.isShown(issue);
    }

    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        if (this.isShow(issue)) {
            this.getOrderableField().populateDefaults(fieldValuesHolder, issue);
        }
    }

    public boolean isRequired() {
        return this.fieldLayoutItem.isRequired();
    }

    public void populateFromIssue(Map fieldValuesHolder, Issue issue) {
        this.getOrderableField().populateFromIssue(fieldValuesHolder, issue);
    }

    public String getRendererType() {
        return this.fieldLayoutItem.getRendererType();
    }

    public FieldLayoutItem getFieldLayoutItem() {
        return this.fieldLayoutItem;
    }

    public FieldScreenLayoutItem getFieldScreenLayoutItem() {
        return this.fieldScreenLayoutItem;
    }
}

