/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.Supplier;
import com.atlassian.util.concurrent.LazyReference;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
abstract class AtomicSupplier<T>
implements Supplier<T> {
    private final AtomicReference<LazyReference<T>> ref = new AtomicReference();

    AtomicSupplier() {
    }

    @NotNull
    public final T get() {
        LazyReference<T> lazyReference = this.ref.get();
        while (lazyReference == null) {
            this.ref.compareAndSet(null, new LazyReference<T>(){

                protected T create() throws Exception {
                    return AtomicSupplier.this.create();
                }
            });
            lazyReference = this.ref.get();
        }
        return (T)lazyReference.get();
    }

    @NotNull
    protected abstract T create();

    public void compareAndSetNull(T expect) {
        LazyReference<T> current = this.ref.get();
        if (expect == current.get()) {
            this.ref.compareAndSet(current, null);
        }
    }
}

