/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.validation;

import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;

public class ProjectRoleMapperValidator {
    public MessageSet validateMappings(I18nHelper i18nHelper, SimpleProjectImportIdMapper simpleProjectImportIdMapper) {
        MessageSetImpl messageSet = new MessageSetImpl();
        for (String oldId : simpleProjectImportIdMapper.getRequiredOldIds()) {
            String newId = simpleProjectImportIdMapper.getMappedId(oldId);
            if (newId != null) continue;
            if (simpleProjectImportIdMapper.getKey(oldId) == null) {
                messageSet.addWarningMessage(i18nHelper.getText("admin.errors.project.import.project.role.validation.orphan", oldId));
                messageSet.addWarningMessageInEnglish("The project role with id '" + oldId + "' can not be resolved into an actual project role in the backup file. Any comments or worklogs that were protected by this project role will no longer have a visibility restriction.");
                continue;
            }
            messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.project.role.validation.does.not.exist", simpleProjectImportIdMapper.getDisplayName(oldId)));
            messageSet.addErrorMessageInEnglish("The Project Role '" + simpleProjectImportIdMapper.getDisplayName(oldId) + "' is required for the import but does not exist in the current JIRA instance.");
        }
        return messageSet;
    }
}

