/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.taskprogress;

import com.atlassian.jira.imports.project.taskprogress.TaskProgressInterval;

public class AbstractSubtaskProgressProcessor {
    private final int numEntities;
    private final long startPercentage;
    private final long interval;

    public AbstractSubtaskProgressProcessor(TaskProgressInterval taskProgressInterval, int numEntities) {
        if (taskProgressInterval == null) {
            this.numEntities = numEntities;
            this.startPercentage = 0L;
            this.interval = 0L;
        } else {
            this.numEntities = numEntities;
            this.startPercentage = taskProgressInterval.getStartPercent();
            this.interval = taskProgressInterval.getEndPercent() - taskProgressInterval.getStartPercent();
        }
    }

    public int getNumEntities() {
        return this.numEntities;
    }

    protected long getOverallPercentageComplete(long entityCount) {
        if (this.numEntities == 0) {
            return this.startPercentage;
        }
        return this.startPercentage + this.interval * entityCount / (long)this.numEntities;
    }
}

