/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalComment;
import com.atlassian.jira.external.beans.ExternalWorklog;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.parser.CommentParser;
import com.atlassian.jira.imports.project.parser.CommentParserImpl;
import com.atlassian.jira.imports.project.parser.WorklogParser;
import com.atlassian.jira.imports.project.parser.WorklogParserImpl;
import java.util.Map;

public class RequiredProjectRolesMapperHandler
implements ImportEntityHandler {
    private CommentParser commentParser;
    private WorklogParser worklogParser;
    private final BackupProject backupProject;
    private final SimpleProjectImportIdMapper projectRoleMapper;

    public RequiredProjectRolesMapperHandler(BackupProject backupProject, SimpleProjectImportIdMapper projectRoleMapper) {
        this.backupProject = backupProject;
        this.projectRoleMapper = projectRoleMapper;
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        if ("Action".equals(entityName)) {
            this.handleComment(attributes);
        } else if ("Worklog".equals(entityName)) {
            this.handleWorklog(attributes);
        }
    }

    private void handleComment(Map attributes) throws ParseException {
        Long roleLevelId;
        ExternalComment externalComment = this.getCommentParser().parse(attributes);
        if (externalComment != null && this.backupProject.containsIssue(externalComment.getIssueId()) && (roleLevelId = externalComment.getRoleLevelId()) != null) {
            this.projectRoleMapper.flagValueAsRequired(roleLevelId.toString());
        }
    }

    private void handleWorklog(Map attributes) throws ParseException {
        Long roleLevelId;
        ExternalWorklog externalWorklog = this.getWorklogParser().parse(attributes);
        if (externalWorklog != null && this.backupProject.containsIssue(externalWorklog.getIssueId()) && (roleLevelId = externalWorklog.getRoleLevelId()) != null) {
            this.projectRoleMapper.flagValueAsRequired(roleLevelId.toString());
        }
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    WorklogParser getWorklogParser() {
        if (this.worklogParser == null) {
            this.worklogParser = new WorklogParserImpl();
        }
        return this.worklogParser;
    }

    CommentParser getCommentParser() {
        if (this.commentParser == null) {
            this.commentParser = new CommentParserImpl();
        }
        return this.commentParser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequiredProjectRolesMapperHandler that = (RequiredProjectRolesMapperHandler)o;
        if (this.backupProject != null ? !this.backupProject.equals(that.backupProject) : that.backupProject != null) {
            return false;
        }
        if (this.commentParser != null ? !this.commentParser.equals(that.commentParser) : that.commentParser != null) {
            return false;
        }
        if (this.projectRoleMapper != null ? !this.projectRoleMapper.equals(that.projectRoleMapper) : that.projectRoleMapper != null) {
            return false;
        }
        return !(this.worklogParser != null ? !this.worklogParser.equals(that.worklogParser) : that.worklogParser != null);
    }

    public int hashCode() {
        int result = this.commentParser != null ? this.commentParser.hashCode() : 0;
        result = 31 * result + (this.worklogParser != null ? this.worklogParser.hashCode() : 0);
        result = 31 * result + (this.backupProject != null ? this.backupProject.hashCode() : 0);
        result = 31 * result + (this.projectRoleMapper != null ? this.projectRoleMapper.hashCode() : 0);
        return result;
    }
}

