/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalUser;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.UserMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RegisterUserMapperHandler
implements ImportEntityHandler {
    private static final Logger log = Logger.getLogger(RegisterUserMapperHandler.class);
    private static final String OS_PROPERTY_ENTRY = "OSPropertyEntry";
    private static final String EXTERNAL_ENTITY = "ExternalEntity";
    private static final String ENTITY_NAME = "entityName";
    private static final String USER = "User";
    private static final String ID = "id";
    private static final String ENTITY_ID = "entityId";
    private static final String OS_PROPERTY_STRING = "OSPropertyString";
    private static final String VALUE = "value";
    private static final String USER_NAME = "userName";
    private static final String DISPLAY_NAME = "displayName";
    private static final String EMAIL = "emailAddress";
    private final UserMapper userMapper;
    private static final String CREDENTIAL = "credential";
    Map<String, UserPropertyKey> osPropertyEntryMap = new HashMap<String, UserPropertyKey>();
    Map<String, ExternalUser> userMap = new HashMap<String, ExternalUser>();
    Map<String, String> externalEntityIdToUsernameMap = new HashMap<String, String>();

    public RegisterUserMapperHandler(UserMapper userMapper) {
        this.userMapper = userMapper;
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        if (entityName.equals(EXTERNAL_ENTITY) && "com.atlassian.jira.user.OfbizExternalEntityStore".equals(attributes.get("type"))) {
            String id = attributes.get(ID);
            if (StringUtils.isEmpty((String)id)) {
                throw new ParseException("Missing 'id' field for ExternalEntity.");
            }
            String username = attributes.get("name");
            if (StringUtils.isEmpty((String)username)) {
                throw new ParseException("Missing name from ExternalEntity id = " + id);
            }
            this.externalEntityIdToUsernameMap.put(id, username);
        } else if (entityName.equals(OS_PROPERTY_ENTRY) && EXTERNAL_ENTITY.equals(attributes.get(ENTITY_NAME))) {
            String osPropertyID = attributes.get(ID);
            if (StringUtils.isEmpty((String)osPropertyID)) {
                throw new ParseException("Missing 'id' field for OSPropertyEntry.");
            }
            String externalEntityId = attributes.get(ENTITY_ID);
            if (StringUtils.isBlank((String)externalEntityId)) {
                throw new ParseException("Missing entityId from OSPropertyEntry id = " + osPropertyID);
            }
            String propertyKey = attributes.get("propertyKey");
            if (StringUtils.isBlank((String)propertyKey)) {
                throw new ParseException("Missing propertyKey from OSPropertyEntry id = " + osPropertyID);
            }
            String username = this.externalEntityIdToUsernameMap.get(externalEntityId);
            if (username == null) {
                log.warn((Object)("Unable to associate a username with ExternalEntity ID '" + externalEntityId + "' when processing OSPropertyEntry " + osPropertyID));
            } else if (UserPropertyKey.isRememberedPropertyKey(propertyKey)) {
                this.osPropertyEntryMap.put(osPropertyID, new UserPropertyKey(username, propertyKey));
            }
        } else if (entityName.equals(OS_PROPERTY_STRING)) {
            String id = attributes.get(ID);
            UserPropertyKey userPropertyKey = this.osPropertyEntryMap.remove(id);
            if (userPropertyKey != null) {
                ExternalUser externalUser = this.userMap.get(userPropertyKey.username);
                if (externalUser == null) {
                    externalUser = new ExternalUser();
                    this.userMap.put(userPropertyKey.username, externalUser);
                }
                String value = attributes.get(VALUE);
                userPropertyKey.addPropertyValueToUser(externalUser, value);
            }
        } else if (entityName.equals(USER)) {
            String email;
            String userId = attributes.get(ID);
            if (StringUtils.isEmpty((String)userId)) {
                throw new ParseException("Missing 'id' field for User entry.");
            }
            String name = attributes.get(USER_NAME);
            if (StringUtils.isEmpty((String)name)) {
                log.warn((Object)("Missing 'userName' field for User entry id = " + userId));
                return;
            }
            String displayName = attributes.get(DISPLAY_NAME);
            if (StringUtils.isEmpty((String)displayName)) {
                log.warn((Object)("Missing 'displayName' field for User entry id = " + userId));
            }
            if (StringUtils.isEmpty((String)(email = attributes.get(EMAIL)))) {
                log.warn((Object)("Missing 'email' field for User entry id = " + userId));
            }
            String credential = attributes.get(CREDENTIAL);
            ExternalUser externalUser = this.userMap.get(name);
            if (externalUser == null) {
                externalUser = new ExternalUser();
                this.userMap.put(name, externalUser);
            }
            externalUser.setId(userId);
            externalUser.setName(name);
            externalUser.setFullname(displayName);
            externalUser.setEmail(email);
            externalUser.setPasswordHash(credential);
            this.userMapper.registerOldValue(externalUser);
        }
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterUserMapperHandler that = (RegisterUserMapperHandler)o;
        if (this.osPropertyEntryMap != null ? !((Object)this.osPropertyEntryMap).equals(that.osPropertyEntryMap) : that.osPropertyEntryMap != null) {
            return false;
        }
        if (this.userMap != null ? !((Object)this.userMap).equals(that.userMap) : that.userMap != null) {
            return false;
        }
        return !(this.userMapper != null ? !this.userMapper.equals(that.userMapper) : that.userMapper != null);
    }

    public int hashCode() {
        int result = this.userMapper != null ? this.userMapper.hashCode() : 0;
        result = 31 * result + (this.osPropertyEntryMap != null ? ((Object)this.osPropertyEntryMap).hashCode() : 0);
        result = 31 * result + (this.userMap != null ? ((Object)this.userMap).hashCode() : 0);
        return result;
    }

    static class UserPropertyKey {
        String username;
        String propertyKey;

        public UserPropertyKey(String username, String propertyKey) {
            this.username = username;
            this.propertyKey = propertyKey;
        }

        public void addPropertyValueToUser(ExternalUser externalUser, String value) {
            if (UserPropertyKey.isRememberedPropertyKey(this.propertyKey)) {
                String simplePropertyKey = this.propertyKey.substring("jira.meta.".length());
                externalUser.setUserProperty(simplePropertyKey, value);
            }
        }

        public static boolean isRememberedPropertyKey(String propertyKey) {
            return propertyKey.startsWith("jira.meta.");
        }
    }
}

