/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.DirectoryEntity;
import org.apache.commons.lang.builder.HashCodeBuilder;

final class DirectoryEntityKey {
    private long directoryId;
    private String name;

    private DirectoryEntityKey(long directoryId, String name) {
        this.directoryId = directoryId;
        this.name = name;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public String getName() {
        return this.name;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectoryEntityKey)) {
            return false;
        }
        DirectoryEntityKey other = (DirectoryEntityKey)o;
        return this.directoryId == other.directoryId && this.name.equals(other.name);
    }

    public final int hashCode() {
        return new HashCodeBuilder(1, 31).append(this.directoryId).append((Object)this.name).toHashCode();
    }

    public static DirectoryEntityKey getKeyPreserveCase(long directoryId, String name) {
        return new DirectoryEntityKey(directoryId, name);
    }

    public static DirectoryEntityKey getKey(long directoryId, String name) {
        return new DirectoryEntityKey(directoryId, IdentifierUtils.toLowerCase((String)name));
    }

    public static DirectoryEntityKey getKey(DirectoryEntity entity) {
        return new DirectoryEntityKey(entity.getDirectoryId(), IdentifierUtils.toLowerCase((String)entity.getName()));
    }
}

