/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.configurator.db.AbstractDatabaseConfig;
import com.atlassian.jira.configurator.db.DatabaseInstance;
import com.atlassian.jira.exception.ParseException;

public class SqlServerDatabaseConfig
extends AbstractDatabaseConfig {
    private static final String MICROSOFT_DRIVER_PREFIX = "jdbc:sqlserver://";
    private static final String JTDS_DRIVER_PREFIX = "jdbc:jtds:sqlserver://";
    private String protocolPrefix;

    @Override
    public String getDatabaseType() {
        return "SQL Server";
    }

    @Override
    public String getInstanceFieldName() {
        return "Database";
    }

    public String getDisplayName() {
        return "SQL Server";
    }

    @Override
    public String getClassName() {
        return "net.sourceforge.jtds.jdbc.Driver";
    }

    @Override
    public String getUrl(String hostname, String port, String instance) {
        if ((port = port.trim()).length() > 0) {
            port = ":" + port;
        }
        if ((instance = instance.trim()).length() > 0) {
            instance = "/" + instance;
        }
        return JTDS_DRIVER_PREFIX + hostname.trim() + port + instance;
    }

    @Override
    public DatabaseInstance parseUrl(String jdbcUrl) throws ParseException {
        if (jdbcUrl.startsWith(MICROSOFT_DRIVER_PREFIX)) {
            this.protocolPrefix = MICROSOFT_DRIVER_PREFIX;
            return this.parseUrlMicrosoftDriver(jdbcUrl);
        }
        this.protocolPrefix = JTDS_DRIVER_PREFIX;
        return this.parseUrlJtdsDriver(jdbcUrl);
    }

    private DatabaseInstance parseUrlJtdsDriver(String jdbcUrl) throws ParseException {
        String[] host_Port;
        DatabaseInstance databaseInstance = new DatabaseInstance();
        String stripped = this.removeProtocolPrefix(jdbcUrl);
        String[] hostPort_Instance = (stripped = stripped.split(";", 2)[0]).split("/");
        if (hostPort_Instance.length > 1) {
            databaseInstance.setInstance(hostPort_Instance[1]);
        }
        if ((host_Port = hostPort_Instance[0].split(":", 2)).length > 1) {
            databaseInstance.setPort(host_Port[1]);
        }
        databaseInstance.setHostname(host_Port[0]);
        return databaseInstance;
    }

    private DatabaseInstance parseUrlMicrosoftDriver(String jdbcUrl) throws ParseException {
        DatabaseInstance databaseInstance = new DatabaseInstance();
        String stripped = this.removeProtocolPrefix(jdbcUrl);
        String[] hostInstance_Port = (stripped = stripped.split(";", 2)[0]).split(":", 2);
        if (hostInstance_Port.length > 1) {
            databaseInstance.setPort(hostInstance_Port[1]);
        }
        String[] host_instance = hostInstance_Port[0].split("\\\\");
        databaseInstance.setHostname(host_instance[0]);
        if (host_instance.length > 1) {
            databaseInstance.setInstance(host_instance[1]);
        }
        return databaseInstance;
    }

    @Override
    protected String getProtocolPrefix() throws ParseException {
        return this.protocolPrefix;
    }
}

