/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.console;

import com.atlassian.jira.configurator.console.DeviceConsoleProvider;
import com.atlassian.jira.configurator.console.StreamConsoleProvider;
import java.io.Console;
import java.io.IOException;

public interface ConsoleProvider {
    public String readLine() throws IOException;

    public String readLine(String var1) throws IOException;

    public boolean readYesNo(String var1, boolean var2) throws IOException;

    public String readPassword(String var1) throws IOException;

    public char readFirstChar(String var1) throws IOException;

    public void print(String var1);

    public void println();

    public void println(String var1);

    public void printErrorMessage(String var1);

    public void printErrorMessage(Throwable var1);

    public void flush();

    public static class Factory {
        private static final ConsoleProvider INSTANCE = Factory.initInstance();

        public static ConsoleProvider getInstance() {
            return INSTANCE;
        }

        private static ConsoleProvider initInstance() {
            Console console = System.console();
            if (console != null) {
                return new DeviceConsoleProvider(console);
            }
            return new StreamConsoleProvider(System.in, System.out);
        }
    }
}

