/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bulkedit.operation.AbstractBulkOperation;
import com.atlassian.jira.bulkedit.operation.BulkEditAction;
import com.atlassian.jira.bulkedit.operation.BulkEditActionImpl;
import com.atlassian.jira.bulkedit.operation.UnavailableBulkEditAction;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class BulkEditOperation
extends AbstractBulkOperation {
    public static final String NAME_KEY = "bulk.edit.operation.name";
    public static final String NAME = "BulkEdit";
    private static final String DESCRIPTION_KEY = "bulk.edit.operation.description";
    private static final String CANNOT_PERFORM_MESSAGE_KEY = "bulk.edit.cannotperform";
    private static final List<String> ALL_SYSTEM_FIELDS = ImmutableList.of((Object)"issuetype", (Object)"security", (Object)"priority", (Object)"fixVersions", (Object)"versions", (Object)"components", (Object)"assignee", (Object)"reporter", (Object)"environment", (Object)"duedate", (Object)"comment", (Object)"labels", (Object[])new String[0]);
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final FieldManager fieldManager;
    private final JiraAuthenticationContext authenticationContext;

    public BulkEditOperation(IssueManager issueManager, PermissionManager permissionManager, ProjectManager projectManager, FieldManager fieldManager, JiraAuthenticationContext authenticationContext) {
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.fieldManager = fieldManager;
        this.authenticationContext = authenticationContext;
    }

    public boolean canPerform(BulkEditBean bulkEditBean, User remoteUser) {
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (issue.isEditable()) continue;
            return false;
        }
        Collection actions = this.getActions(bulkEditBean, remoteUser).values();
        for (BulkEditAction bulkEditAction : actions) {
            if (!bulkEditAction.isAvailable(bulkEditBean)) continue;
            return true;
        }
        return false;
    }

    public Map getActions(BulkEditBean bulkEditBean, User remoteUser) {
        ListOrderedMap actions = new ListOrderedMap();
        for (String actionName : ALL_SYSTEM_FIELDS) {
            actions.put(actionName, this.buildBulkEditAction(actionName));
        }
        actions.putAll(this.getCustomFieldActions(bulkEditBean, remoteUser));
        return actions;
    }

    private BulkEditAction buildBulkEditAction(String fieldId) {
        return new BulkEditActionImpl(fieldId, this.fieldManager, this.authenticationContext);
    }

    public Map getCustomFieldActions(BulkEditBean bulkEditBean, User remoteUser) {
        if (!bulkEditBean.isMultipleProjects()) {
            Long l = (Long)bulkEditBean.getProjectIds().iterator().next();
        }
        SearchContextImpl searchContext = new SearchContextImpl(null, new ArrayList(bulkEditBean.getProjectIds()), new ArrayList(bulkEditBean.getIssueTypes()));
        List customFields = ComponentAccessor.getCustomFieldManager().getCustomFieldObjects((SearchContext)searchContext);
        ArrayList<CustomField> availableCustomFields = new ArrayList<CustomField>();
        for (int i = 0; i < customFields.size(); ++i) {
            CustomField customField = (CustomField)customFields.get(i);
            for (FieldLayout fieldLayout : bulkEditBean.getFieldLayouts()) {
                if (fieldLayout.isFieldHidden(customField.getId())) continue;
                availableCustomFields.add(customField);
            }
        }
        if (!availableCustomFields.isEmpty()) {
            for (Long projectId : bulkEditBean.getProjectIds()) {
                if (this.hasPermission(12, this.projectManager.getProjectObj(projectId), remoteUser)) continue;
                return EasyMap.build(null, (Object)new UnavailableBulkEditAction("common.concepts.customfields", "bulk.edit.unavailable.customfields", this.authenticationContext));
            }
            ListOrderedMap bulkEditActions = new ListOrderedMap();
            for (CustomField customField : availableCustomFields) {
                bulkEditActions.put(customField.getId(), this.buildBulkEditAction(customField.getId()));
            }
            return bulkEditActions;
        }
        return EasyMap.build(null, (Object)new UnavailableBulkEditAction("common.concepts.customfields", "bulk.edit.unavailable.customfields", this.authenticationContext));
    }

    private boolean hasPermission(int permission, Project project, User remoteUser) {
        return this.permissionManager.hasPermission(permission, project, remoteUser);
    }

    public void perform(BulkEditBean bulkEditBean, User remoteUser) throws Exception {
        boolean sendMail = bulkEditBean.isSendBulkNotification();
        for (MutableIssue issue : bulkEditBean.getSelectedIssues()) {
            for (BulkEditAction bulkEditAction : bulkEditBean.getActions().values()) {
                OrderableField field = bulkEditAction.getField();
                FieldLayoutItem fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout(issue.getProjectObject(), issue.getIssueTypeObject().getId()).getFieldLayoutItem(field);
                field.updateIssue(fieldLayoutItem, issue, bulkEditBean.getFieldValuesHolder());
            }
            this.issueManager.updateIssue(remoteUser, issue, EventDispatchOption.ISSUE_UPDATED, sendMail);
        }
    }

    public String getNameKey() {
        return NAME_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof BulkEditOperation;
    }

    public String getOperationName() {
        return NAME;
    }

    public String getCannotPerformMessageKey() {
        return CANNOT_PERFORM_MESSAGE_KEY;
    }
}

